<?php

namespace EnumType;

/**
 * This class stands for contractStatus EnumType
 * @subpackage Enumerations
 */
class ContractStatus
{
    /**
     * Constant for value 'canceled'
     * @return string 'canceled'
     */
    const VALUE_CANCELED = 'canceled';
    /**
     * Constant for value 'closed'
     * @return string 'closed'
     */
    const VALUE_CLOSED = 'closed';
    /**
     * Constant for value 'deleted'
     * @return string 'deleted'
     */
    const VALUE_DELETED = 'deleted';
    /**
     * Constant for value 'draft'
     * @return string 'draft'
     */
    const VALUE_DRAFT = 'draft';
    /**
     * Constant for value 'expired'
     * @return string 'expired'
     */
    const VALUE_EXPIRED = 'expired';
    /**
     * Constant for value 'submited'
     * @return string 'submited'
     */
    const VALUE_SUBMITED = 'submited';
    /**
     * Constant for value 'suspended'
     * @return string 'suspended'
     */
    const VALUE_SUSPENDED = 'suspended';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_DRAFT
     * @uses self::VALUE_EXPIRED
     * @uses self::VALUE_SUBMITED
     * @uses self::VALUE_SUSPENDED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CANCELED,
            self::VALUE_CLOSED,
            self::VALUE_DELETED,
            self::VALUE_DRAFT,
            self::VALUE_EXPIRED,
            self::VALUE_SUBMITED,
            self::VALUE_SUSPENDED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
