<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'RequestToken' => '\\StructType\\RequestToken',
            'checkConnexionRequest' => '\\StructType\\CheckConnexionRequest',
            'checkConnexionResponse' => '\\StructType\\CheckConnexionResponse',
            'contractDetailRequest' => '\\StructType\\ContractDetailRequest',
            'contractDetailResponse' => '\\StructType\\ContractDetailResponse',
            'contract' => '\\StructType\\Contract',
            'signatories' => '\\StructType\\Signatories',
            'signatory' => '\\StructType\\Signatory',
            'mainDocuments' => '\\StructType\\MainDocuments',
            'document' => '\\StructType\\Document',
            'annexeDocuments' => '\\StructType\\AnnexeDocuments',
            'contractListRequest' => '\\StructType\\ContractListRequest',
            'createDate' => '\\StructType\\CreateDate',
            'signDueDate' => '\\StructType\\SignDueDate',
            'contractListResponse' => '\\StructType\\ContractListResponse',
            'contracts' => '\\StructType\\Contracts',
            'contractCreateRequest' => '\\StructType\\ContractCreateRequest',
            'signPosition' => '\\StructType\\SignPosition',
            'actions' => '\\StructType\\Actions',
            'notify' => '\\StructType\\Notify',
            'contractCreateResponse' => '\\StructType\\ContractCreateResponse',
            'signatorySignRequest' => '\\StructType\\SignatorySignRequest',
            'signatorySignResponse' => '\\StructType\\SignatorySignResponse',
            'contractDeleteRequest' => '\\StructType\\ContractDeleteRequest',
            'contractDeleteResponse' => '\\StructType\\ContractDeleteResponse',
            'contractCancelRequest' => '\\StructType\\ContractCancelRequest',
            'contractCancelResponse' => '\\StructType\\ContractCancelResponse',
            'contractFinalizeRequest' => '\\StructType\\ContractFinalizeRequest',
            'contractFinalizeResponse' => '\\StructType\\ContractFinalizeResponse',
            'signatorySendSmsRequest' => '\\StructType\\SignatorySendSmsRequest',
            'signatorySendSmsResponse' => '\\StructType\\SignatorySendSmsResponse',
            'signatorySendAllSmsRequest' => '\\StructType\\SignatorySendAllSmsRequest',
            'signatorySendAllSmsResponse' => '\\StructType\\SignatorySendAllSmsResponse',
            'signatorySendOneSmsRequest' => '\\StructType\\SignatorySendOneSmsRequest',
            'signatorySendOneSmsResponse' => '\\StructType\\SignatorySendOneSmsResponse',
        );
    }
}
