<?php

namespace EFALIA\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestToken StructType
 * @subpackage Structs
 */
class RequestToken extends AbstractStructBase
{
    /**
     * The apiKey
     * @var string
     */
    public $apiKey;
    /**
     * The apiUser
     * @var string
     */
    public $apiUser;
    /**
     * Constructor method for RequestToken
     * @uses RequestToken::setApiKey()
     * @uses RequestToken::setApiUser()
     * @param string $apiKey
     * @param string $apiUser
     */
    public function __construct($apiKey = null, $apiUser = null)
    {
        $this
            ->setApiKey($apiKey)
            ->setApiUser($apiUser);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \EFALIA\StructType\RequestToken
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiKey, true), gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get apiUser value
     * @return string|null
     */
    public function getApiUser()
    {
        return $this->apiUser;
    }
    /**
     * Set apiUser value
     * @param string $apiUser
     * @return \EFALIA\StructType\RequestToken
     */
    public function setApiUser($apiUser = null)
    {
        // validation for constraint: string
        if (!is_null($apiUser) && !is_string($apiUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiUser, true), gettype($apiUser)), __LINE__);
        }
        $this->apiUser = $apiUser;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EFALIA\StructType\RequestToken
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
