<?php

namespace EFALIA\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contracts StructType
 * @subpackage Structs
 */
class Contracts extends AbstractStructBase
{
    /**
     * The contract
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \EFALIA\StructType\Contract[]
     */
    public $contract;
    /**
     * Constructor method for contracts
     * @uses Contracts::setContract()
     * @param \EFALIA\StructType\Contract[] $contract
     */
    public function __construct(array $contract = array())
    {
        $this
            ->setContract($contract);
    }
    /**
     * Get contract value
     * @return \EFALIA\StructType\Contract[]|null
     */
    public function getContract()
    {
        return $this->contract;
    }
    /**
     * This method is responsible for validating the values passed to the setContract method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContract method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContractForArrayConstraintsFromSetContract(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contractsContractItem) {
            // validation for constraint: itemType
            if (!$contractsContractItem instanceof \EFALIA\StructType\Contract) {
                $invalidValues[] = is_object($contractsContractItem) ? get_class($contractsContractItem) : sprintf('%s(%s)', gettype($contractsContractItem), var_export($contractsContractItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The contract property can only contain items of type \EFALIA\StructType\Contract, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set contract value
     * @throws \InvalidArgumentException
     * @param \EFALIA\StructType\Contract[] $contract
     * @return \EFALIA\StructType\Contracts
     */
    public function setContract(array $contract = array())
    {
        // validation for constraint: array
        if ('' !== ($contractArrayErrorMessage = self::validateContractForArrayConstraintsFromSetContract($contract))) {
            throw new \InvalidArgumentException($contractArrayErrorMessage, __LINE__);
        }
        $this->contract = $contract;
        return $this;
    }
    /**
     * Add item to contract value
     * @throws \InvalidArgumentException
     * @param \EFALIA\StructType\Contract $item
     * @return \EFALIA\StructType\Contracts
     */
    public function addToContract(\EFALIA\StructType\Contract $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \EFALIA\StructType\Contract) {
            throw new \InvalidArgumentException(sprintf('The contract property can only contain items of type \EFALIA\StructType\Contract, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->contract[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EFALIA\StructType\Contracts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
