<?php

namespace EFALIA\EnumType;

/**
 * This class stands for contractType EnumType
 * @subpackage Enumerations
 */
class ContractType
{
    /**
     * Constant for value 'classique'
     * @return string 'classique'
     */
    const VALUE_CLASSIQUE = 'classique';
    /**
     * Constant for value 'devis_mono'
     * @return string 'devis_mono'
     */
    const VALUE_DEVIS_MONO = 'devis_mono';
    /**
     * Constant for value 'devis_bi'
     * @return string 'devis_bi'
     */
    const VALUE_DEVIS_BI = 'devis_bi';
    /**
     * Constant for value 'emargement'
     * @return string 'emargement'
     */
    const VALUE_EMARGEMENT = 'emargement';
    /**
     * Constant for value 'travail'
     * @return string 'travail'
     */
    const VALUE_TRAVAIL = 'travail';
    /**
     * Constant for value 'location'
     * @return string 'location'
     */
    const VALUE_LOCATION = 'location';
    /**
     * Constant for value 'assurance'
     * @return string 'assurance'
     */
    const VALUE_ASSURANCE = 'assurance';
    /**
     * Constant for value 'horo'
     * @return string 'horo'
     */
    const VALUE_HORO = 'horo';
    /**
     * Constant for value 'custom'
     * @return string 'custom'
     */
    const VALUE_CUSTOM = 'custom';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLASSIQUE
     * @uses self::VALUE_DEVIS_MONO
     * @uses self::VALUE_DEVIS_BI
     * @uses self::VALUE_EMARGEMENT
     * @uses self::VALUE_TRAVAIL
     * @uses self::VALUE_LOCATION
     * @uses self::VALUE_ASSURANCE
     * @uses self::VALUE_HORO
     * @uses self::VALUE_CUSTOM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLASSIQUE,
            self::VALUE_DEVIS_MONO,
            self::VALUE_DEVIS_BI,
            self::VALUE_EMARGEMENT,
            self::VALUE_TRAVAIL,
            self::VALUE_LOCATION,
            self::VALUE_ASSURANCE,
            self::VALUE_HORO,
            self::VALUE_CUSTOM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
