<?php

namespace EFALIA;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'RequestToken' => '\\EFALIA\\StructType\\RequestToken',
            'checkConnexionRequest' => '\\EFALIA\\StructType\\CheckConnexionRequest',
            'checkConnexionResponse' => '\\EFALIA\\StructType\\CheckConnexionResponse',
            'contractDetailRequest' => '\\EFALIA\\StructType\\ContractDetailRequest',
            'contractDetailResponse' => '\\EFALIA\\StructType\\ContractDetailResponse',
            'contract' => '\\EFALIA\\StructType\\Contract',
            'signatories' => '\\EFALIA\\StructType\\Signatories',
            'signatory' => '\\EFALIA\\StructType\\Signatory',
            'mainDocuments' => '\\EFALIA\\StructType\\MainDocuments',
            'document' => '\\EFALIA\\StructType\\Document',
            'annexeDocuments' => '\\EFALIA\\StructType\\AnnexeDocuments',
            'contractListRequest' => '\\EFALIA\\StructType\\ContractListRequest',
            'createDate' => '\\EFALIA\\StructType\\CreateDate',
            'signDueDate' => '\\EFALIA\\StructType\\SignDueDate',
            'contractListResponse' => '\\EFALIA\\StructType\\ContractListResponse',
            'contracts' => '\\EFALIA\\StructType\\Contracts',
            'contractCreateRequest' => '\\EFALIA\\StructType\\ContractCreateRequest',
            'signPosition' => '\\EFALIA\\StructType\\SignPosition',
            'actions' => '\\EFALIA\\StructType\\Actions',
            'notify' => '\\EFALIA\\StructType\\Notify',
            'contractCreateResponse' => '\\EFALIA\\StructType\\ContractCreateResponse',
            'signatorySignRequest' => '\\EFALIA\\StructType\\SignatorySignRequest',
            'signatorySignResponse' => '\\EFALIA\\StructType\\SignatorySignResponse',
            'contractDeleteRequest' => '\\EFALIA\\StructType\\ContractDeleteRequest',
            'contractDeleteResponse' => '\\EFALIA\\StructType\\ContractDeleteResponse',
            'contractCancelRequest' => '\\EFALIA\\StructType\\ContractCancelRequest',
            'contractCancelResponse' => '\\EFALIA\\StructType\\ContractCancelResponse',
            'contractFinalizeRequest' => '\\EFALIA\\StructType\\ContractFinalizeRequest',
            'contractFinalizeResponse' => '\\EFALIA\\StructType\\ContractFinalizeResponse',
            'signatorySendSmsRequest' => '\\EFALIA\\StructType\\SignatorySendSmsRequest',
            'signatorySendSmsResponse' => '\\EFALIA\\StructType\\SignatorySendSmsResponse',
            'signatorySendAllSmsRequest' => '\\EFALIA\\StructType\\SignatorySendAllSmsRequest',
            'signatorySendAllSmsResponse' => '\\EFALIA\\StructType\\SignatorySendAllSmsResponse',
            'signatorySendOneSmsRequest' => '\\EFALIA\\StructType\\SignatorySendOneSmsRequest',
            'signatorySendOneSmsResponse' => '\\EFALIA\\StructType\\SignatorySendOneSmsResponse',
        );
    }
}
