<?php

namespace EFALIA\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for signatorySendOneSmsRequest StructType
 * @subpackage Structs
 */
class SignatorySendOneSmsRequest extends AbstractStructBase
{
    /**
     * The requestToken
     * @var \EFALIA\StructType\RequestToken
     */
    public $requestToken;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * The signatories
     * @var \EFALIA\StructType\Signatories
     */
    public $signatories;
    /**
     * Constructor method for signatorySendOneSmsRequest
     * @uses SignatorySendOneSmsRequest::setRequestToken()
     * @uses SignatorySendOneSmsRequest::setLanguage()
     * @uses SignatorySendOneSmsRequest::setSignatories()
     * @param \EFALIA\StructType\RequestToken $requestToken
     * @param string $language
     * @param \EFALIA\StructType\Signatories $signatories
     */
    public function __construct(\EFALIA\StructType\RequestToken $requestToken = null, $language = null, \EFALIA\StructType\Signatories $signatories = null)
    {
        $this
            ->setRequestToken($requestToken)
            ->setLanguage($language)
            ->setSignatories($signatories);
    }
    /**
     * Get requestToken value
     * @return \EFALIA\StructType\RequestToken|null
     */
    public function getRequestToken()
    {
        return $this->requestToken;
    }
    /**
     * Set requestToken value
     * @param \EFALIA\StructType\RequestToken $requestToken
     * @return \EFALIA\StructType\SignatorySendOneSmsRequest
     */
    public function setRequestToken(\EFALIA\StructType\RequestToken $requestToken = null)
    {
        $this->requestToken = $requestToken;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @uses \EFALIA\EnumType\Language::valueIsValid()
     * @uses \EFALIA\EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \EFALIA\StructType\SignatorySendOneSmsRequest
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EFALIA\EnumType\Language::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EFALIA\EnumType\Language', is_array($language) ? implode(', ', $language) : var_export($language, true), implode(', ', \EFALIA\EnumType\Language::getValidValues())), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get signatories value
     * @return \EFALIA\StructType\Signatories|null
     */
    public function getSignatories()
    {
        return $this->signatories;
    }
    /**
     * Set signatories value
     * @param \EFALIA\StructType\Signatories $signatories
     * @return \EFALIA\StructType\SignatorySendOneSmsRequest
     */
    public function setSignatories(\EFALIA\StructType\Signatories $signatories = null)
    {
        $this->signatories = $signatories;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EFALIA\StructType\SignatorySendOneSmsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
