<?php

namespace EFALIA\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for signatory StructType
 * @subpackage Structs
 */
class Signatory extends AbstractStructBase
{
    /**
     * The publicId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $publicId;
    /**
     * The actionDate
     * @var string
     */
    public $actionDate;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $email;
    /**
     * The firstname
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $firstname;
    /**
     * The lastname
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $lastname;
    /**
     * The organization
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $organization;
    /**
     * The phoneNumber
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $phoneNumber;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The payment
     * Meta information extracted from the WSDL
     * - base: xs:int
     * - maxInclusive: 50000
     * - minInclusive: 0
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $payment;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * The signPosition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \EFALIA\StructType\SignPosition
     */
    public $signPosition;
    /**
     * The contractId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $contractId;
    /**
     * The signatoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $signatoryId;
    /**
     * Constructor method for signatory
     * @uses Signatory::setPublicId()
     * @uses Signatory::setActionDate()
     * @uses Signatory::setEmail()
     * @uses Signatory::setFirstname()
     * @uses Signatory::setLastname()
     * @uses Signatory::setOrganization()
     * @uses Signatory::setPhoneNumber()
     * @uses Signatory::setStatus()
     * @uses Signatory::setPayment()
     * @uses Signatory::setExternalId()
     * @uses Signatory::setSignPosition()
     * @uses Signatory::setContractId()
     * @uses Signatory::setSignatoryId()
     * @param string $publicId
     * @param string $actionDate
     * @param string $email
     * @param string $firstname
     * @param string $lastname
     * @param string $organization
     * @param string $phoneNumber
     * @param string $status
     * @param int $payment
     * @param string $externalId
     * @param \EFALIA\StructType\SignPosition $signPosition
     * @param string $contractId
     * @param string $signatoryId
     */
    public function __construct($publicId = null, $actionDate = null, $email = null, $firstname = null, $lastname = null, $organization = null, $phoneNumber = null, $status = null, $payment = null, $externalId = null, \EFALIA\StructType\SignPosition $signPosition = null, $contractId = null, $signatoryId = null)
    {
        $this
            ->setPublicId($publicId)
            ->setActionDate($actionDate)
            ->setEmail($email)
            ->setFirstname($firstname)
            ->setLastname($lastname)
            ->setOrganization($organization)
            ->setPhoneNumber($phoneNumber)
            ->setStatus($status)
            ->setPayment($payment)
            ->setExternalId($externalId)
            ->setSignPosition($signPosition)
            ->setContractId($contractId)
            ->setSignatoryId($signatoryId);
    }
    /**
     * Get publicId value
     * @return string|null
     */
    public function getPublicId()
    {
        return $this->publicId;
    }
    /**
     * Set publicId value
     * @param string $publicId
     * @return \EFALIA\StructType\Signatory
     */
    public function setPublicId($publicId = null)
    {
        // validation for constraint: string
        if (!is_null($publicId) && !is_string($publicId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicId, true), gettype($publicId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($publicId) && mb_strlen($publicId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($publicId)), __LINE__);
        }
        $this->publicId = $publicId;
        return $this;
    }
    /**
     * Get actionDate value
     * @return string|null
     */
    public function getActionDate()
    {
        return $this->actionDate;
    }
    /**
     * Set actionDate value
     * @param string $actionDate
     * @return \EFALIA\StructType\Signatory
     */
    public function setActionDate($actionDate = null)
    {
        // validation for constraint: string
        if (!is_null($actionDate) && !is_string($actionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionDate, true), gettype($actionDate)), __LINE__);
        }
        $this->actionDate = $actionDate;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \EFALIA\StructType\Signatory
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($email) && mb_strlen($email) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \EFALIA\StructType\Signatory
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($firstname) && mb_strlen($firstname) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \EFALIA\StructType\Signatory
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastname, true), gettype($lastname)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($lastname) && mb_strlen($lastname) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($lastname)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get organization value
     * @return string|null
     */
    public function getOrganization()
    {
        return $this->organization;
    }
    /**
     * Set organization value
     * @param string $organization
     * @return \EFALIA\StructType\Signatory
     */
    public function setOrganization($organization = null)
    {
        // validation for constraint: string
        if (!is_null($organization) && !is_string($organization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organization, true), gettype($organization)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($organization) && mb_strlen($organization) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($organization)), __LINE__);
        }
        $this->organization = $organization;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param string $phoneNumber
     * @return \EFALIA\StructType\Signatory
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($phoneNumber) && mb_strlen($phoneNumber) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($phoneNumber)), __LINE__);
        }
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EFALIA\EnumType\SignatoryStatus::valueIsValid()
     * @uses \EFALIA\EnumType\SignatoryStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \EFALIA\StructType\Signatory
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EFALIA\EnumType\SignatoryStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EFALIA\EnumType\SignatoryStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EFALIA\EnumType\SignatoryStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get payment value
     * @return int|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @param int $payment
     * @return \EFALIA\StructType\Signatory
     */
    public function setPayment($payment = null)
    {
        // validation for constraint: int
        if (!is_null($payment) && !(is_int($payment) || ctype_digit($payment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payment, true), gettype($payment)), __LINE__);
        }
        // validation for constraint: maxInclusive(50000)
        if (!is_null($payment) && $payment > 50000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 50000', var_export($payment, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($payment) && $payment < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($payment, true)), __LINE__);
        }
        $this->payment = $payment;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \EFALIA\StructType\Signatory
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Get signPosition value
     * @return \EFALIA\StructType\SignPosition|null
     */
    public function getSignPosition()
    {
        return $this->signPosition;
    }
    /**
     * Set signPosition value
     * @param \EFALIA\StructType\SignPosition $signPosition
     * @return \EFALIA\StructType\Signatory
     */
    public function setSignPosition(\EFALIA\StructType\SignPosition $signPosition = null)
    {
        $this->signPosition = $signPosition;
        return $this;
    }
    /**
     * Get contractId value
     * @return string|null
     */
    public function getContractId()
    {
        return $this->contractId;
    }
    /**
     * Set contractId value
     * @param string $contractId
     * @return \EFALIA\StructType\Signatory
     */
    public function setContractId($contractId = null)
    {
        // validation for constraint: string
        if (!is_null($contractId) && !is_string($contractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractId, true), gettype($contractId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($contractId) && mb_strlen($contractId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($contractId)), __LINE__);
        }
        $this->contractId = $contractId;
        return $this;
    }
    /**
     * Get signatoryId value
     * @return string|null
     */
    public function getSignatoryId()
    {
        return $this->signatoryId;
    }
    /**
     * Set signatoryId value
     * @param string $signatoryId
     * @return \EFALIA\StructType\Signatory
     */
    public function setSignatoryId($signatoryId = null)
    {
        // validation for constraint: string
        if (!is_null($signatoryId) && !is_string($signatoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatoryId, true), gettype($signatoryId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($signatoryId) && mb_strlen($signatoryId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($signatoryId)), __LINE__);
        }
        $this->signatoryId = $signatoryId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EFALIA\StructType\Signatory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
