<?php

namespace EFALIA\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for signPosition StructType
 * @subpackage Structs
 */
class SignPosition extends AbstractStructBase
{
    /**
     * The page
     * @var int
     */
    public $page;
    /**
     * The x1
     * @var int
     */
    public $x1;
    /**
     * The y1
     * @var int
     */
    public $y1;
    /**
     * The x2
     * @var int
     */
    public $x2;
    /**
     * The y2
     * @var int
     */
    public $y2;
    /**
     * Constructor method for signPosition
     * @uses SignPosition::setPage()
     * @uses SignPosition::setX1()
     * @uses SignPosition::setY1()
     * @uses SignPosition::setX2()
     * @uses SignPosition::setY2()
     * @param int $page
     * @param int $x1
     * @param int $y1
     * @param int $x2
     * @param int $y2
     */
    public function __construct($page = null, $x1 = null, $y1 = null, $x2 = null, $y2 = null)
    {
        $this
            ->setPage($page)
            ->setX1($x1)
            ->setY1($y1)
            ->setX2($x2)
            ->setY2($y2);
    }
    /**
     * Get page value
     * @return int|null
     */
    public function getPage()
    {
        return $this->page;
    }
    /**
     * Set page value
     * @param int $page
     * @return \EFALIA\StructType\SignPosition
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !(is_int($page) || ctype_digit($page))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page, true), gettype($page)), __LINE__);
        }
        $this->page = $page;
        return $this;
    }
    /**
     * Get x1 value
     * @return int|null
     */
    public function getX1()
    {
        return $this->x1;
    }
    /**
     * Set x1 value
     * @param int $x1
     * @return \EFALIA\StructType\SignPosition
     */
    public function setX1($x1 = null)
    {
        // validation for constraint: int
        if (!is_null($x1) && !(is_int($x1) || ctype_digit($x1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($x1, true), gettype($x1)), __LINE__);
        }
        $this->x1 = $x1;
        return $this;
    }
    /**
     * Get y1 value
     * @return int|null
     */
    public function getY1()
    {
        return $this->y1;
    }
    /**
     * Set y1 value
     * @param int $y1
     * @return \EFALIA\StructType\SignPosition
     */
    public function setY1($y1 = null)
    {
        // validation for constraint: int
        if (!is_null($y1) && !(is_int($y1) || ctype_digit($y1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($y1, true), gettype($y1)), __LINE__);
        }
        $this->y1 = $y1;
        return $this;
    }
    /**
     * Get x2 value
     * @return int|null
     */
    public function getX2()
    {
        return $this->x2;
    }
    /**
     * Set x2 value
     * @param int $x2
     * @return \EFALIA\StructType\SignPosition
     */
    public function setX2($x2 = null)
    {
        // validation for constraint: int
        if (!is_null($x2) && !(is_int($x2) || ctype_digit($x2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($x2, true), gettype($x2)), __LINE__);
        }
        $this->x2 = $x2;
        return $this;
    }
    /**
     * Get y2 value
     * @return int|null
     */
    public function getY2()
    {
        return $this->y2;
    }
    /**
     * Set y2 value
     * @param int $y2
     * @return \EFALIA\StructType\SignPosition
     */
    public function setY2($y2 = null)
    {
        // validation for constraint: int
        if (!is_null($y2) && !(is_int($y2) || ctype_digit($y2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($y2, true), gettype($y2)), __LINE__);
        }
        $this->y2 = $y2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EFALIA\StructType\SignPosition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
