<?php

namespace EFALIA\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contractDetailResponse StructType
 * @subpackage Structs
 */
class ContractDetailResponse extends AbstractStructBase
{
    /**
     * The contract
     * @var \EFALIA\StructType\Contract
     */
    public $contract;
    /**
     * The signatories
     * @var \EFALIA\StructType\Signatories
     */
    public $signatories;
    /**
     * The mainDocuments
     * @var \EFALIA\StructType\MainDocuments
     */
    public $mainDocuments;
    /**
     * The annexeDocuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \EFALIA\StructType\AnnexeDocuments
     */
    public $annexeDocuments;
    /**
     * The log
     * @var string
     */
    public $log;
    /**
     * Constructor method for contractDetailResponse
     * @uses ContractDetailResponse::setContract()
     * @uses ContractDetailResponse::setSignatories()
     * @uses ContractDetailResponse::setMainDocuments()
     * @uses ContractDetailResponse::setAnnexeDocuments()
     * @uses ContractDetailResponse::setLog()
     * @param \EFALIA\StructType\Contract $contract
     * @param \EFALIA\StructType\Signatories $signatories
     * @param \EFALIA\StructType\MainDocuments $mainDocuments
     * @param \EFALIA\StructType\AnnexeDocuments $annexeDocuments
     * @param string $log
     */
    public function __construct(\EFALIA\StructType\Contract $contract = null, \EFALIA\StructType\Signatories $signatories = null, \EFALIA\StructType\MainDocuments $mainDocuments = null, \EFALIA\StructType\AnnexeDocuments $annexeDocuments = null, $log = null)
    {
        $this
            ->setContract($contract)
            ->setSignatories($signatories)
            ->setMainDocuments($mainDocuments)
            ->setAnnexeDocuments($annexeDocuments)
            ->setLog($log);
    }
    /**
     * Get contract value
     * @return \EFALIA\StructType\Contract|null
     */
    public function getContract()
    {
        return $this->contract;
    }
    /**
     * Set contract value
     * @param \EFALIA\StructType\Contract $contract
     * @return \EFALIA\StructType\ContractDetailResponse
     */
    public function setContract(\EFALIA\StructType\Contract $contract = null)
    {
        $this->contract = $contract;
        return $this;
    }
    /**
     * Get signatories value
     * @return \EFALIA\StructType\Signatories|null
     */
    public function getSignatories()
    {
        return $this->signatories;
    }
    /**
     * Set signatories value
     * @param \EFALIA\StructType\Signatories $signatories
     * @return \EFALIA\StructType\ContractDetailResponse
     */
    public function setSignatories(\EFALIA\StructType\Signatories $signatories = null)
    {
        $this->signatories = $signatories;
        return $this;
    }
    /**
     * Get mainDocuments value
     * @return \EFALIA\StructType\MainDocuments|null
     */
    public function getMainDocuments()
    {
        return $this->mainDocuments;
    }
    /**
     * Set mainDocuments value
     * @param \EFALIA\StructType\MainDocuments $mainDocuments
     * @return \EFALIA\StructType\ContractDetailResponse
     */
    public function setMainDocuments(\EFALIA\StructType\MainDocuments $mainDocuments = null)
    {
        $this->mainDocuments = $mainDocuments;
        return $this;
    }
    /**
     * Get annexeDocuments value
     * @return \EFALIA\StructType\AnnexeDocuments|null
     */
    public function getAnnexeDocuments()
    {
        return $this->annexeDocuments;
    }
    /**
     * Set annexeDocuments value
     * @param \EFALIA\StructType\AnnexeDocuments $annexeDocuments
     * @return \EFALIA\StructType\ContractDetailResponse
     */
    public function setAnnexeDocuments(\EFALIA\StructType\AnnexeDocuments $annexeDocuments = null)
    {
        $this->annexeDocuments = $annexeDocuments;
        return $this;
    }
    /**
     * Get log value
     * @return string|null
     */
    public function getLog()
    {
        return $this->log;
    }
    /**
     * Set log value
     * @param string $log
     * @return \EFALIA\StructType\ContractDetailResponse
     */
    public function setLog($log = null)
    {
        // validation for constraint: string
        if (!is_null($log) && !is_string($log)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($log, true), gettype($log)), __LINE__);
        }
        $this->log = $log;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EFALIA\StructType\ContractDetailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
