<?php

namespace EFALIA\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Signatory ServiceType
 * @subpackage Services
 */
class Signatory extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named signatorySendSms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \EFALIA\StructType\SignatorySendSmsRequest $signatorySendSmsRequest
     * @return \EFALIA\StructType\SignatorySendSmsResponse|bool
     */
    public function signatorySendSms(\EFALIA\StructType\SignatorySendSmsRequest $signatorySendSmsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->signatorySendSms($signatorySendSmsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named signatorySendAllSms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \EFALIA\StructType\SignatorySendAllSmsRequest $signatorySendAllSmsRequest
     * @return \EFALIA\StructType\SignatorySendAllSmsResponse|bool
     */
    public function signatorySendAllSms(\EFALIA\StructType\SignatorySendAllSmsRequest $signatorySendAllSmsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->signatorySendAllSms($signatorySendAllSmsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named signatorySendOneSms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \EFALIA\StructType\SignatorySendOneSmsRequest $signatorySendOneSmsRequest
     * @return \EFALIA\StructType\SignatorySendOneSmsResponse|bool
     */
    public function signatorySendOneSms(\EFALIA\StructType\SignatorySendOneSmsRequest $signatorySendOneSmsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->signatorySendOneSms($signatorySendOneSmsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named signatorySign
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \EFALIA\StructType\SignatorySignRequest $signatorySignRequest
     * @return \EFALIA\StructType\SignatorySignResponse|bool
     */
    public function signatorySign(\EFALIA\StructType\SignatorySignRequest $signatorySignRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->signatorySign($signatorySignRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \EFALIA\StructType\SignatorySendAllSmsResponse|\EFALIA\StructType\SignatorySendOneSmsResponse|\EFALIA\StructType\SignatorySendSmsResponse|\EFALIA\StructType\SignatorySignResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
