<?php

namespace EFALIA\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Contract ServiceType
 * @subpackage Services
 */
class Contract extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named contractDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \EFALIA\StructType\ContractDeleteRequest $contractDeleteRequest
     * @return \EFALIA\StructType\ContractDeleteResponse|bool
     */
    public function contractDelete(\EFALIA\StructType\ContractDeleteRequest $contractDeleteRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->contractDelete($contractDeleteRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contractCancel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \EFALIA\StructType\ContractCancelRequest $contractCancelRequest
     * @return \EFALIA\StructType\ContractCancelResponse|bool
     */
    public function contractCancel(\EFALIA\StructType\ContractCancelRequest $contractCancelRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->contractCancel($contractCancelRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contractCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \EFALIA\StructType\ContractCreateRequest $contractCreateRequest
     * @return \EFALIA\StructType\ContractCreateResponse|bool
     */
    public function contractCreate(\EFALIA\StructType\ContractCreateRequest $contractCreateRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->contractCreate($contractCreateRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contractDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \EFALIA\StructType\ContractDetailRequest $contractDetailRequest
     * @return \EFALIA\StructType\ContractDetailResponse|bool
     */
    public function contractDetail(\EFALIA\StructType\ContractDetailRequest $contractDetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->contractDetail($contractDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contractFinalize
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \EFALIA\StructType\ContractFinalizeRequest $contractFinalizeRequest
     * @return \EFALIA\StructType\ContractFinalizeResponse|bool
     */
    public function contractFinalize(\EFALIA\StructType\ContractFinalizeRequest $contractFinalizeRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->contractFinalize($contractFinalizeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named contractList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \EFALIA\StructType\ContractListRequest $contractListRequest
     * @return \EFALIA\StructType\ContractListResponse|bool
     */
    public function contractList(\EFALIA\StructType\ContractListRequest $contractListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->contractList($contractListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \EFALIA\StructType\ContractCancelResponse|\EFALIA\StructType\ContractCreateResponse|\EFALIA\StructType\ContractDeleteResponse|\EFALIA\StructType\ContractDetailResponse|\EFALIA\StructType\ContractFinalizeResponse|\EFALIA\StructType\ContractListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
