<?php

namespace EFALIA\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for signatories StructType
 * @subpackage Structs
 */
class Signatories extends AbstractStructBase
{
    /**
     * The signatory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \EFALIA\StructType\Signatory[]
     */
    public $signatory;
    /**
     * Constructor method for signatories
     * @uses Signatories::setSignatory()
     * @param \EFALIA\StructType\Signatory[] $signatory
     */
    public function __construct(array $signatory = array())
    {
        $this
            ->setSignatory($signatory);
    }
    /**
     * Get signatory value
     * @return \EFALIA\StructType\Signatory[]
     */
    public function getSignatory()
    {
        return $this->signatory;
    }
    /**
     * This method is responsible for validating the values passed to the setSignatory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSignatory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSignatoryForArrayConstraintsFromSetSignatory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $signatoriesSignatoryItem) {
            // validation for constraint: itemType
            if (!$signatoriesSignatoryItem instanceof \EFALIA\StructType\Signatory) {
                $invalidValues[] = is_object($signatoriesSignatoryItem) ? get_class($signatoriesSignatoryItem) : sprintf('%s(%s)', gettype($signatoriesSignatoryItem), var_export($signatoriesSignatoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The signatory property can only contain items of type \EFALIA\StructType\Signatory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set signatory value
     * @throws \InvalidArgumentException
     * @param \EFALIA\StructType\Signatory[] $signatory
     * @return \EFALIA\StructType\Signatories
     */
    public function setSignatory(array $signatory = array())
    {
        // validation for constraint: array
        if ('' !== ($signatoryArrayErrorMessage = self::validateSignatoryForArrayConstraintsFromSetSignatory($signatory))) {
            throw new \InvalidArgumentException($signatoryArrayErrorMessage, __LINE__);
        }
        $this->signatory = $signatory;
        return $this;
    }
    /**
     * Add item to signatory value
     * @throws \InvalidArgumentException
     * @param \EFALIA\StructType\Signatory $item
     * @return \EFALIA\StructType\Signatories
     */
    public function addToSignatory(\EFALIA\StructType\Signatory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \EFALIA\StructType\Signatory) {
            throw new \InvalidArgumentException(sprintf('The signatory property can only contain items of type \EFALIA\StructType\Signatory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->signatory[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EFALIA\StructType\Signatories
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
