<?php

namespace EFALIA\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contractCreateResponse StructType
 * @subpackage Structs
 */
class ContractCreateResponse extends AbstractStructBase
{
    /**
     * The publicId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 255
     * @var string
     */
    public $publicId;
    /**
     * The signatories
     * @var \EFALIA\StructType\Signatories
     */
    public $signatories;
    /**
     * Constructor method for contractCreateResponse
     * @uses ContractCreateResponse::setPublicId()
     * @uses ContractCreateResponse::setSignatories()
     * @param string $publicId
     * @param \EFALIA\StructType\Signatories $signatories
     */
    public function __construct($publicId = null, \EFALIA\StructType\Signatories $signatories = null)
    {
        $this
            ->setPublicId($publicId)
            ->setSignatories($signatories);
    }
    /**
     * Get publicId value
     * @return string|null
     */
    public function getPublicId()
    {
        return $this->publicId;
    }
    /**
     * Set publicId value
     * @param string $publicId
     * @return \EFALIA\StructType\ContractCreateResponse
     */
    public function setPublicId($publicId = null)
    {
        // validation for constraint: string
        if (!is_null($publicId) && !is_string($publicId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicId, true), gettype($publicId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($publicId) && mb_strlen($publicId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($publicId)), __LINE__);
        }
        $this->publicId = $publicId;
        return $this;
    }
    /**
     * Get signatories value
     * @return \EFALIA\StructType\Signatories|null
     */
    public function getSignatories()
    {
        return $this->signatories;
    }
    /**
     * Set signatories value
     * @param \EFALIA\StructType\Signatories $signatories
     * @return \EFALIA\StructType\ContractCreateResponse
     */
    public function setSignatories(\EFALIA\StructType\Signatories $signatories = null)
    {
        $this->signatories = $signatories;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EFALIA\StructType\ContractCreateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
