<?php

namespace EFALIA\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contractCreateRequest StructType
 * @subpackage Structs
 */
class ContractCreateRequest extends AbstractStructBase
{
    /**
     * The requestToken
     * @var \EFALIA\StructType\RequestToken
     */
    public $requestToken;
    /**
     * The contract
     * @var \EFALIA\StructType\Contract
     */
    public $contract;
    /**
     * The mainDocuments
     * @var \EFALIA\StructType\MainDocuments
     */
    public $mainDocuments;
    /**
     * The annexeDocuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \EFALIA\StructType\AnnexeDocuments
     */
    public $annexeDocuments;
    /**
     * The signatories
     * @var \EFALIA\StructType\Signatories
     */
    public $signatories;
    /**
     * The actions
     * @var \EFALIA\StructType\Actions
     */
    public $actions;
    /**
     * The notify
     * @var \EFALIA\StructType\Notify
     */
    public $notify;
    /**
     * Constructor method for contractCreateRequest
     * @uses ContractCreateRequest::setRequestToken()
     * @uses ContractCreateRequest::setContract()
     * @uses ContractCreateRequest::setMainDocuments()
     * @uses ContractCreateRequest::setAnnexeDocuments()
     * @uses ContractCreateRequest::setSignatories()
     * @uses ContractCreateRequest::setActions()
     * @uses ContractCreateRequest::setNotify()
     * @param \EFALIA\StructType\RequestToken $requestToken
     * @param \EFALIA\StructType\Contract $contract
     * @param \EFALIA\StructType\MainDocuments $mainDocuments
     * @param \EFALIA\StructType\AnnexeDocuments $annexeDocuments
     * @param \EFALIA\StructType\Signatories $signatories
     * @param \EFALIA\StructType\Actions $actions
     * @param \EFALIA\StructType\Notify $notify
     */
    public function __construct(\EFALIA\StructType\RequestToken $requestToken = null, \EFALIA\StructType\Contract $contract = null, \EFALIA\StructType\MainDocuments $mainDocuments = null, \EFALIA\StructType\AnnexeDocuments $annexeDocuments = null, \EFALIA\StructType\Signatories $signatories = null, \EFALIA\StructType\Actions $actions = null, \EFALIA\StructType\Notify $notify = null)
    {
        $this
            ->setRequestToken($requestToken)
            ->setContract($contract)
            ->setMainDocuments($mainDocuments)
            ->setAnnexeDocuments($annexeDocuments)
            ->setSignatories($signatories)
            ->setActions($actions)
            ->setNotify($notify);
    }
    /**
     * Get requestToken value
     * @return \EFALIA\StructType\RequestToken|null
     */
    public function getRequestToken()
    {
        return $this->requestToken;
    }
    /**
     * Set requestToken value
     * @param \EFALIA\StructType\RequestToken $requestToken
     * @return \EFALIA\StructType\ContractCreateRequest
     */
    public function setRequestToken(\EFALIA\StructType\RequestToken $requestToken = null)
    {
        $this->requestToken = $requestToken;
        return $this;
    }
    /**
     * Get contract value
     * @return \EFALIA\StructType\Contract|null
     */
    public function getContract()
    {
        return $this->contract;
    }
    /**
     * Set contract value
     * @param \EFALIA\StructType\Contract $contract
     * @return \EFALIA\StructType\ContractCreateRequest
     */
    public function setContract(\EFALIA\StructType\Contract $contract = null)
    {
        $this->contract = $contract;
        return $this;
    }
    /**
     * Get mainDocuments value
     * @return \EFALIA\StructType\MainDocuments|null
     */
    public function getMainDocuments()
    {
        return $this->mainDocuments;
    }
    /**
     * Set mainDocuments value
     * @param \EFALIA\StructType\MainDocuments $mainDocuments
     * @return \EFALIA\StructType\ContractCreateRequest
     */
    public function setMainDocuments(\EFALIA\StructType\MainDocuments $mainDocuments = null)
    {
        $this->mainDocuments = $mainDocuments;
        return $this;
    }
    /**
     * Get annexeDocuments value
     * @return \EFALIA\StructType\AnnexeDocuments|null
     */
    public function getAnnexeDocuments()
    {
        return $this->annexeDocuments;
    }
    /**
     * Set annexeDocuments value
     * @param \EFALIA\StructType\AnnexeDocuments $annexeDocuments
     * @return \EFALIA\StructType\ContractCreateRequest
     */
    public function setAnnexeDocuments(\EFALIA\StructType\AnnexeDocuments $annexeDocuments = null)
    {
        $this->annexeDocuments = $annexeDocuments;
        return $this;
    }
    /**
     * Get signatories value
     * @return \EFALIA\StructType\Signatories|null
     */
    public function getSignatories()
    {
        return $this->signatories;
    }
    /**
     * Set signatories value
     * @param \EFALIA\StructType\Signatories $signatories
     * @return \EFALIA\StructType\ContractCreateRequest
     */
    public function setSignatories(\EFALIA\StructType\Signatories $signatories = null)
    {
        $this->signatories = $signatories;
        return $this;
    }
    /**
     * Get actions value
     * @return \EFALIA\StructType\Actions|null
     */
    public function getActions()
    {
        return $this->actions;
    }
    /**
     * Set actions value
     * @param \EFALIA\StructType\Actions $actions
     * @return \EFALIA\StructType\ContractCreateRequest
     */
    public function setActions(\EFALIA\StructType\Actions $actions = null)
    {
        $this->actions = $actions;
        return $this;
    }
    /**
     * Get notify value
     * @return \EFALIA\StructType\Notify|null
     */
    public function getNotify()
    {
        return $this->notify;
    }
    /**
     * Set notify value
     * @param \EFALIA\StructType\Notify $notify
     * @return \EFALIA\StructType\ContractCreateRequest
     */
    public function setNotify(\EFALIA\StructType\Notify $notify = null)
    {
        $this->notify = $notify;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EFALIA\StructType\ContractCreateRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
