<?php

namespace EFALIA\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for annexeDocuments StructType
 * @subpackage Structs
 */
class AnnexeDocuments extends AbstractStructBase
{
    /**
     * The document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \EFALIA\StructType\Document[]
     */
    public $document;
    /**
     * Constructor method for annexeDocuments
     * @uses AnnexeDocuments::setDocument()
     * @param \EFALIA\StructType\Document[] $document
     */
    public function __construct(array $document = array())
    {
        $this
            ->setDocument($document);
    }
    /**
     * Get document value
     * @return \EFALIA\StructType\Document[]|null
     */
    public function getDocument()
    {
        return $this->document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $annexeDocumentsDocumentItem) {
            // validation for constraint: itemType
            if (!$annexeDocumentsDocumentItem instanceof \EFALIA\StructType\Document) {
                $invalidValues[] = is_object($annexeDocumentsDocumentItem) ? get_class($annexeDocumentsDocumentItem) : sprintf('%s(%s)', gettype($annexeDocumentsDocumentItem), var_export($annexeDocumentsDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The document property can only contain items of type \EFALIA\StructType\Document, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set document value
     * @throws \InvalidArgumentException
     * @param \EFALIA\StructType\Document[] $document
     * @return \EFALIA\StructType\AnnexeDocuments
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        $this->document = $document;
        return $this;
    }
    /**
     * Add item to document value
     * @throws \InvalidArgumentException
     * @param \EFALIA\StructType\Document $item
     * @return \EFALIA\StructType\AnnexeDocuments
     */
    public function addToDocument(\EFALIA\StructType\Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \EFALIA\StructType\Document) {
            throw new \InvalidArgumentException(sprintf('The document property can only contain items of type \EFALIA\StructType\Document, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->document[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \EFALIA\StructType\AnnexeDocuments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
