<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for position StructType
 * @subpackage Structs
 */
class Position extends AbstractStructBase
{
    /**
     * The posNr
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $posNr;
    /**
     * The articleNr
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * - minLength: 1
     * @var string
     */
    public $articleNr;
    /**
     * The netPrice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $netPrice;
    /**
     * The taxPercentage
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $taxPercentage;
    /**
     * The taxSum
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $taxSum;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $quantity;
    /**
     * The dlvDate
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $dlvDate;
    /**
     * The serialNr
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $serialNr;
    /**
     * Constructor method for position
     * @uses Position::setPosNr()
     * @uses Position::setArticleNr()
     * @uses Position::setNetPrice()
     * @uses Position::setTaxPercentage()
     * @uses Position::setTaxSum()
     * @uses Position::setQuantity()
     * @uses Position::setDlvDate()
     * @uses Position::setSerialNr()
     * @param string $posNr
     * @param string $articleNr
     * @param string $netPrice
     * @param string $taxPercentage
     * @param string $taxSum
     * @param string $quantity
     * @param string $dlvDate
     * @param string $serialNr
     */
    public function __construct($posNr = null, $articleNr = null, $netPrice = null, $taxPercentage = null, $taxSum = null, $quantity = null, $dlvDate = null, $serialNr = null)
    {
        $this
            ->setPosNr($posNr)
            ->setArticleNr($articleNr)
            ->setNetPrice($netPrice)
            ->setTaxPercentage($taxPercentage)
            ->setTaxSum($taxSum)
            ->setQuantity($quantity)
            ->setDlvDate($dlvDate)
            ->setSerialNr($serialNr);
    }
    /**
     * Get posNr value
     * @return string|null
     */
    public function getPosNr()
    {
        return $this->posNr;
    }
    /**
     * Set posNr value
     * @param string $posNr
     * @return \StructType\Position
     */
    public function setPosNr($posNr = null)
    {
        // validation for constraint: string
        if (!is_null($posNr) && !is_string($posNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($posNr, true), gettype($posNr)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($posNr) && mb_strlen($posNr) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($posNr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($posNr) && mb_strlen($posNr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($posNr)), __LINE__);
        }
        $this->posNr = $posNr;
        return $this;
    }
    /**
     * Get articleNr value
     * @return string|null
     */
    public function getArticleNr()
    {
        return $this->articleNr;
    }
    /**
     * Set articleNr value
     * @param string $articleNr
     * @return \StructType\Position
     */
    public function setArticleNr($articleNr = null)
    {
        // validation for constraint: string
        if (!is_null($articleNr) && !is_string($articleNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleNr, true), gettype($articleNr)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($articleNr) && mb_strlen($articleNr) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($articleNr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($articleNr) && mb_strlen($articleNr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($articleNr)), __LINE__);
        }
        $this->articleNr = $articleNr;
        return $this;
    }
    /**
     * Get netPrice value
     * @return string|null
     */
    public function getNetPrice()
    {
        return $this->netPrice;
    }
    /**
     * Set netPrice value
     * @param string $netPrice
     * @return \StructType\Position
     */
    public function setNetPrice($netPrice = null)
    {
        // validation for constraint: string
        if (!is_null($netPrice) && !is_string($netPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netPrice, true), gettype($netPrice)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($netPrice) && mb_strlen($netPrice) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($netPrice)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($netPrice) && mb_strlen($netPrice) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($netPrice)), __LINE__);
        }
        $this->netPrice = $netPrice;
        return $this;
    }
    /**
     * Get taxPercentage value
     * @return string|null
     */
    public function getTaxPercentage()
    {
        return $this->taxPercentage;
    }
    /**
     * Set taxPercentage value
     * @param string $taxPercentage
     * @return \StructType\Position
     */
    public function setTaxPercentage($taxPercentage = null)
    {
        // validation for constraint: string
        if (!is_null($taxPercentage) && !is_string($taxPercentage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPercentage, true), gettype($taxPercentage)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($taxPercentage) && mb_strlen($taxPercentage) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($taxPercentage)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taxPercentage) && mb_strlen($taxPercentage) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taxPercentage)), __LINE__);
        }
        $this->taxPercentage = $taxPercentage;
        return $this;
    }
    /**
     * Get taxSum value
     * @return string|null
     */
    public function getTaxSum()
    {
        return $this->taxSum;
    }
    /**
     * Set taxSum value
     * @param string $taxSum
     * @return \StructType\Position
     */
    public function setTaxSum($taxSum = null)
    {
        // validation for constraint: string
        if (!is_null($taxSum) && !is_string($taxSum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxSum, true), gettype($taxSum)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($taxSum) && mb_strlen($taxSum) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($taxSum)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taxSum) && mb_strlen($taxSum) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taxSum)), __LINE__);
        }
        $this->taxSum = $taxSum;
        return $this;
    }
    /**
     * Get quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\Position
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($quantity) && mb_strlen($quantity) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($quantity)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($quantity) && mb_strlen($quantity) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get dlvDate value
     * @return string|null
     */
    public function getDlvDate()
    {
        return $this->dlvDate;
    }
    /**
     * Set dlvDate value
     * @param string $dlvDate
     * @return \StructType\Position
     */
    public function setDlvDate($dlvDate = null)
    {
        // validation for constraint: string
        if (!is_null($dlvDate) && !is_string($dlvDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dlvDate, true), gettype($dlvDate)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($dlvDate) && mb_strlen($dlvDate) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($dlvDate)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($dlvDate) && mb_strlen($dlvDate) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($dlvDate)), __LINE__);
        }
        $this->dlvDate = $dlvDate;
        return $this;
    }
    /**
     * Get serialNr value
     * @return string|null
     */
    public function getSerialNr()
    {
        return $this->serialNr;
    }
    /**
     * Set serialNr value
     * @param string $serialNr
     * @return \StructType\Position
     */
    public function setSerialNr($serialNr = null)
    {
        // validation for constraint: string
        if (!is_null($serialNr) && !is_string($serialNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNr, true), gettype($serialNr)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($serialNr) && mb_strlen($serialNr) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($serialNr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($serialNr) && mb_strlen($serialNr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($serialNr)), __LINE__);
        }
        $this->serialNr = $serialNr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Position
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
