<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for header StructType
 * @subpackage Structs
 */
class Header extends AbstractStructBase
{
    /**
     * The orderPositionsType
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 1
     * @var string
     */
    public $orderPositionsType;
    /**
     * The orderNr
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $orderNr;
    /**
     * The orderDate
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $orderDate;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 1
     * @var string
     */
    public $language;
    /**
     * The referenceNr
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $referenceNr;
    /**
     * The sameAdrDlvBill
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 1
     * @var string
     */
    public $sameAdrDlvBill;
    /**
     * The orderSum
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * @var \StructType\OrderSum[]
     */
    public $orderSum;
    /**
     * The netSum
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $netSum;
    /**
     * The taxSum
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $taxSum;
    /**
     * The grossSum
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $grossSum;
    /**
     * The paymentType
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $paymentType;
    /**
     * The orderType
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4
     * - minLength: 1
     * @var string
     */
    public $orderType;
    /**
     * Constructor method for header
     * @uses Header::setOrderPositionsType()
     * @uses Header::setOrderNr()
     * @uses Header::setOrderDate()
     * @uses Header::setLanguage()
     * @uses Header::setReferenceNr()
     * @uses Header::setSameAdrDlvBill()
     * @uses Header::setOrderSum()
     * @uses Header::setNetSum()
     * @uses Header::setTaxSum()
     * @uses Header::setGrossSum()
     * @uses Header::setPaymentType()
     * @uses Header::setOrderType()
     * @param string $orderPositionsType
     * @param string $orderNr
     * @param string $orderDate
     * @param string $language
     * @param string $referenceNr
     * @param string $sameAdrDlvBill
     * @param \StructType\OrderSum[] $orderSum
     * @param string $netSum
     * @param string $taxSum
     * @param string $grossSum
     * @param string $paymentType
     * @param string $orderType
     */
    public function __construct($orderPositionsType = null, $orderNr = null, $orderDate = null, $language = null, $referenceNr = null, $sameAdrDlvBill = null, array $orderSum = array(), $netSum = null, $taxSum = null, $grossSum = null, $paymentType = null, $orderType = null)
    {
        $this
            ->setOrderPositionsType($orderPositionsType)
            ->setOrderNr($orderNr)
            ->setOrderDate($orderDate)
            ->setLanguage($language)
            ->setReferenceNr($referenceNr)
            ->setSameAdrDlvBill($sameAdrDlvBill)
            ->setOrderSum($orderSum)
            ->setNetSum($netSum)
            ->setTaxSum($taxSum)
            ->setGrossSum($grossSum)
            ->setPaymentType($paymentType)
            ->setOrderType($orderType);
    }
    /**
     * Get orderPositionsType value
     * @return string|null
     */
    public function getOrderPositionsType()
    {
        return $this->orderPositionsType;
    }
    /**
     * Set orderPositionsType value
     * @param string $orderPositionsType
     * @return \StructType\Header
     */
    public function setOrderPositionsType($orderPositionsType = null)
    {
        // validation for constraint: string
        if (!is_null($orderPositionsType) && !is_string($orderPositionsType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderPositionsType, true), gettype($orderPositionsType)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($orderPositionsType) && mb_strlen($orderPositionsType) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($orderPositionsType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($orderPositionsType) && mb_strlen($orderPositionsType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($orderPositionsType)), __LINE__);
        }
        $this->orderPositionsType = $orderPositionsType;
        return $this;
    }
    /**
     * Get orderNr value
     * @return string|null
     */
    public function getOrderNr()
    {
        return $this->orderNr;
    }
    /**
     * Set orderNr value
     * @param string $orderNr
     * @return \StructType\Header
     */
    public function setOrderNr($orderNr = null)
    {
        // validation for constraint: string
        if (!is_null($orderNr) && !is_string($orderNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNr, true), gettype($orderNr)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($orderNr) && mb_strlen($orderNr) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($orderNr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($orderNr) && mb_strlen($orderNr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($orderNr)), __LINE__);
        }
        $this->orderNr = $orderNr;
        return $this;
    }
    /**
     * Get orderDate value
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->orderDate;
    }
    /**
     * Set orderDate value
     * @param string $orderDate
     * @return \StructType\Header
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDate, true), gettype($orderDate)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($orderDate) && mb_strlen($orderDate) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($orderDate)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($orderDate) && mb_strlen($orderDate) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($orderDate)), __LINE__);
        }
        $this->orderDate = $orderDate;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\Header
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($language) && mb_strlen($language) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($language)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($language) && mb_strlen($language) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get referenceNr value
     * @return string|null
     */
    public function getReferenceNr()
    {
        return $this->referenceNr;
    }
    /**
     * Set referenceNr value
     * @param string $referenceNr
     * @return \StructType\Header
     */
    public function setReferenceNr($referenceNr = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNr) && !is_string($referenceNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNr, true), gettype($referenceNr)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($referenceNr) && mb_strlen($referenceNr) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($referenceNr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenceNr) && mb_strlen($referenceNr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenceNr)), __LINE__);
        }
        $this->referenceNr = $referenceNr;
        return $this;
    }
    /**
     * Get sameAdrDlvBill value
     * @return string|null
     */
    public function getSameAdrDlvBill()
    {
        return $this->sameAdrDlvBill;
    }
    /**
     * Set sameAdrDlvBill value
     * @param string $sameAdrDlvBill
     * @return \StructType\Header
     */
    public function setSameAdrDlvBill($sameAdrDlvBill = null)
    {
        // validation for constraint: string
        if (!is_null($sameAdrDlvBill) && !is_string($sameAdrDlvBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sameAdrDlvBill, true), gettype($sameAdrDlvBill)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($sameAdrDlvBill) && mb_strlen($sameAdrDlvBill) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($sameAdrDlvBill)), __LINE__);
        }
        $this->sameAdrDlvBill = $sameAdrDlvBill;
        return $this;
    }
    /**
     * Get orderSum value
     * @return \StructType\OrderSum[]|null
     */
    public function getOrderSum()
    {
        return $this->orderSum;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderSum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderSum method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderSumForArrayConstraintsFromSetOrderSum(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $headerOrderSumItem) {
            // validation for constraint: itemType
            if (!$headerOrderSumItem instanceof \StructType\OrderSum) {
                $invalidValues[] = is_object($headerOrderSumItem) ? get_class($headerOrderSumItem) : sprintf('%s(%s)', gettype($headerOrderSumItem), var_export($headerOrderSumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderSum property can only contain items of type \StructType\OrderSum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderSum value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderSum[] $orderSum
     * @return \StructType\Header
     */
    public function setOrderSum(array $orderSum = array())
    {
        // validation for constraint: array
        if ('' !== ($orderSumArrayErrorMessage = self::validateOrderSumForArrayConstraintsFromSetOrderSum($orderSum))) {
            throw new \InvalidArgumentException($orderSumArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($orderSum) && count($orderSum) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($orderSum)), __LINE__);
        }
        $this->orderSum = $orderSum;
        return $this;
    }
    /**
     * Add item to orderSum value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderSum $item
     * @return \StructType\Header
     */
    public function addToOrderSum(\StructType\OrderSum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderSum) {
            throw new \InvalidArgumentException(sprintf('The orderSum property can only contain items of type \StructType\OrderSum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->orderSum) && count($this->orderSum) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->orderSum)), __LINE__);
        }
        $this->orderSum[] = $item;
        return $this;
    }
    /**
     * Get netSum value
     * @return string|null
     */
    public function getNetSum()
    {
        return $this->netSum;
    }
    /**
     * Set netSum value
     * @param string $netSum
     * @return \StructType\Header
     */
    public function setNetSum($netSum = null)
    {
        // validation for constraint: string
        if (!is_null($netSum) && !is_string($netSum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netSum, true), gettype($netSum)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($netSum) && mb_strlen($netSum) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($netSum)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($netSum) && mb_strlen($netSum) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($netSum)), __LINE__);
        }
        $this->netSum = $netSum;
        return $this;
    }
    /**
     * Get taxSum value
     * @return string|null
     */
    public function getTaxSum()
    {
        return $this->taxSum;
    }
    /**
     * Set taxSum value
     * @param string $taxSum
     * @return \StructType\Header
     */
    public function setTaxSum($taxSum = null)
    {
        // validation for constraint: string
        if (!is_null($taxSum) && !is_string($taxSum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxSum, true), gettype($taxSum)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($taxSum) && mb_strlen($taxSum) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($taxSum)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taxSum) && mb_strlen($taxSum) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taxSum)), __LINE__);
        }
        $this->taxSum = $taxSum;
        return $this;
    }
    /**
     * Get grossSum value
     * @return string|null
     */
    public function getGrossSum()
    {
        return $this->grossSum;
    }
    /**
     * Set grossSum value
     * @param string $grossSum
     * @return \StructType\Header
     */
    public function setGrossSum($grossSum = null)
    {
        // validation for constraint: string
        if (!is_null($grossSum) && !is_string($grossSum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grossSum, true), gettype($grossSum)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($grossSum) && mb_strlen($grossSum) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($grossSum)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($grossSum) && mb_strlen($grossSum) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($grossSum)), __LINE__);
        }
        $this->grossSum = $grossSum;
        return $this;
    }
    /**
     * Get paymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param string $paymentType
     * @return \StructType\Header
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($paymentType) && mb_strlen($paymentType) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($paymentType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($paymentType) && mb_strlen($paymentType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get orderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->orderType;
    }
    /**
     * Set orderType value
     * @param string $orderType
     * @return \StructType\Header
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: string
        if (!is_null($orderType) && !is_string($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderType, true), gettype($orderType)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($orderType) && mb_strlen($orderType) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($orderType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($orderType) && mb_strlen($orderType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($orderType)), __LINE__);
        }
        $this->orderType = $orderType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Header
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
