<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DT_CUST_AND_ORDER StructType
 * Meta information extracted from the WSDL
 * - documentation: Customer data for cust. registration from KSE Shop to ERP
 * @subpackage Structs
 */
class DT_CUST_AND_ORDER extends AbstractStructBase
{
    /**
     * The order
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Order[]
     */
    public $order;
    /**
     * Constructor method for DT_CUST_AND_ORDER
     * @uses DT_CUST_AND_ORDER::setOrder()
     * @param \StructType\Order[] $order
     */
    public function __construct(array $order = array())
    {
        $this
            ->setOrder($order);
    }
    /**
     * Get order value
     * @return \StructType\Order[]|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dT_CUST_AND_ORDEROrderItem) {
            // validation for constraint: itemType
            if (!$dT_CUST_AND_ORDEROrderItem instanceof \StructType\Order) {
                $invalidValues[] = is_object($dT_CUST_AND_ORDEROrderItem) ? get_class($dT_CUST_AND_ORDEROrderItem) : sprintf('%s(%s)', gettype($dT_CUST_AND_ORDEROrderItem), var_export($dT_CUST_AND_ORDEROrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The order property can only contain items of type \StructType\Order, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set order value
     * @throws \InvalidArgumentException
     * @param \StructType\Order[] $order
     * @return \StructType\DT_CUST_AND_ORDER
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Add item to order value
     * @throws \InvalidArgumentException
     * @param \StructType\Order $item
     * @return \StructType\DT_CUST_AND_ORDER
     */
    public function addToOrder(\StructType\Order $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Order) {
            throw new \InvalidArgumentException(sprintf('The order property can only contain items of type \StructType\Order, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->order[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DT_CUST_AND_ORDER
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
