<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SICUSTANDORDER ServiceType
 * @subpackage Services
 */
class SICUSTANDORDER extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SI_CUST_AND_ORDER
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DT_CUST_AND_ORDER $mT_CUST_AND_ORDER
     * @return void|bool
     */
    public function SI_CUST_AND_ORDER(\StructType\DT_CUST_AND_ORDER $mT_CUST_AND_ORDER)
    {
        try {
            $this->setResult($this->getSoapClient()->SI_CUST_AND_ORDER($mT_CUST_AND_ORDER));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
