<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderSum StructType
 * @subpackage Structs
 */
class OrderSum extends AbstractStructBase
{
    /**
     * The qualifier
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4
     * - minLength: 1
     * @var string
     */
    public $qualifier;
    /**
     * The sum
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $sum;
    /**
     * Constructor method for orderSum
     * @uses OrderSum::setQualifier()
     * @uses OrderSum::setSum()
     * @param string $qualifier
     * @param string $sum
     */
    public function __construct($qualifier = null, $sum = null)
    {
        $this
            ->setQualifier($qualifier)
            ->setSum($sum);
    }
    /**
     * Get qualifier value
     * @return string|null
     */
    public function getQualifier()
    {
        return $this->qualifier;
    }
    /**
     * Set qualifier value
     * @param string $qualifier
     * @return \StructType\OrderSum
     */
    public function setQualifier($qualifier = null)
    {
        // validation for constraint: string
        if (!is_null($qualifier) && !is_string($qualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualifier, true), gettype($qualifier)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($qualifier) && mb_strlen($qualifier) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($qualifier)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($qualifier) && mb_strlen($qualifier) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($qualifier)), __LINE__);
        }
        $this->qualifier = $qualifier;
        return $this;
    }
    /**
     * Get sum value
     * @return string|null
     */
    public function getSum()
    {
        return $this->sum;
    }
    /**
     * Set sum value
     * @param string $sum
     * @return \StructType\OrderSum
     */
    public function setSum($sum = null)
    {
        // validation for constraint: string
        if (!is_null($sum) && !is_string($sum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sum, true), gettype($sum)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($sum) && mb_strlen($sum) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($sum)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($sum) && mb_strlen($sum) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($sum)), __LINE__);
        }
        $this->sum = $sum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderSum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
