<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderData StructType
 * @subpackage Structs
 */
class OrderData extends AbstractStructBase
{
    /**
     * The billingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BillingAddress
     */
    public $billingAddress;
    /**
     * The deliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeliveryAddress
     */
    public $deliveryAddress;
    /**
     * The header
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Header
     */
    public $header;
    /**
     * The position
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Position[]
     */
    public $position;
    /**
     * Constructor method for orderData
     * @uses OrderData::setBillingAddress()
     * @uses OrderData::setDeliveryAddress()
     * @uses OrderData::setHeader()
     * @uses OrderData::setPosition()
     * @param \StructType\BillingAddress $billingAddress
     * @param \StructType\DeliveryAddress $deliveryAddress
     * @param \StructType\Header $header
     * @param \StructType\Position[] $position
     */
    public function __construct(\StructType\BillingAddress $billingAddress = null, \StructType\DeliveryAddress $deliveryAddress = null, \StructType\Header $header = null, array $position = array())
    {
        $this
            ->setBillingAddress($billingAddress)
            ->setDeliveryAddress($deliveryAddress)
            ->setHeader($header)
            ->setPosition($position);
    }
    /**
     * Get billingAddress value
     * @return \StructType\BillingAddress|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\BillingAddress $billingAddress
     * @return \StructType\OrderData
     */
    public function setBillingAddress(\StructType\BillingAddress $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get deliveryAddress value
     * @return \StructType\DeliveryAddress|null
     */
    public function getDeliveryAddress()
    {
        return $this->deliveryAddress;
    }
    /**
     * Set deliveryAddress value
     * @param \StructType\DeliveryAddress $deliveryAddress
     * @return \StructType\OrderData
     */
    public function setDeliveryAddress(\StructType\DeliveryAddress $deliveryAddress = null)
    {
        $this->deliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get header value
     * @return \StructType\Header|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param \StructType\Header $header
     * @return \StructType\OrderData
     */
    public function setHeader(\StructType\Header $header = null)
    {
        $this->header = $header;
        return $this;
    }
    /**
     * Get position value
     * @return \StructType\Position[]|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePositionForArrayConstraintsFromSetPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderDataPositionItem) {
            // validation for constraint: itemType
            if (!$orderDataPositionItem instanceof \StructType\Position) {
                $invalidValues[] = is_object($orderDataPositionItem) ? get_class($orderDataPositionItem) : sprintf('%s(%s)', gettype($orderDataPositionItem), var_export($orderDataPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The position property can only contain items of type \StructType\Position, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position[] $position
     * @return \StructType\OrderData
     */
    public function setPosition(array $position = array())
    {
        // validation for constraint: array
        if ('' !== ($positionArrayErrorMessage = self::validatePositionForArrayConstraintsFromSetPosition($position))) {
            throw new \InvalidArgumentException($positionArrayErrorMessage, __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Add item to position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position $item
     * @return \StructType\OrderData
     */
    public function addToPosition(\StructType\Position $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position) {
            throw new \InvalidArgumentException(sprintf('The position property can only contain items of type \StructType\Position, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->position[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
