<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for order StructType
 * @subpackage Structs
 */
class Order extends AbstractStructBase
{
    /**
     * The statusSAP
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $statusSAP;
    /**
     * The customerData
     * @var \StructType\CustomerData
     */
    public $customerData;
    /**
     * The orderData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderData
     */
    public $orderData;
    /**
     * Constructor method for order
     * @uses Order::setStatusSAP()
     * @uses Order::setCustomerData()
     * @uses Order::setOrderData()
     * @param string $statusSAP
     * @param \StructType\CustomerData $customerData
     * @param \StructType\OrderData $orderData
     */
    public function __construct($statusSAP = null, \StructType\CustomerData $customerData = null, \StructType\OrderData $orderData = null)
    {
        $this
            ->setStatusSAP($statusSAP)
            ->setCustomerData($customerData)
            ->setOrderData($orderData);
    }
    /**
     * Get statusSAP value
     * @return string|null
     */
    public function getStatusSAP()
    {
        return $this->statusSAP;
    }
    /**
     * Set statusSAP value
     * @param string $statusSAP
     * @return \StructType\Order
     */
    public function setStatusSAP($statusSAP = null)
    {
        // validation for constraint: string
        if (!is_null($statusSAP) && !is_string($statusSAP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusSAP, true), gettype($statusSAP)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($statusSAP) && mb_strlen($statusSAP) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($statusSAP)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($statusSAP) && mb_strlen($statusSAP) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($statusSAP)), __LINE__);
        }
        $this->statusSAP = $statusSAP;
        return $this;
    }
    /**
     * Get customerData value
     * @return \StructType\CustomerData|null
     */
    public function getCustomerData()
    {
        return $this->customerData;
    }
    /**
     * Set customerData value
     * @param \StructType\CustomerData $customerData
     * @return \StructType\Order
     */
    public function setCustomerData(\StructType\CustomerData $customerData = null)
    {
        $this->customerData = $customerData;
        return $this;
    }
    /**
     * Get orderData value
     * @return \StructType\OrderData|null
     */
    public function getOrderData()
    {
        return $this->orderData;
    }
    /**
     * Set orderData value
     * @param \StructType\OrderData $orderData
     * @return \StructType\Order
     */
    public function setOrderData(\StructType\OrderData $orderData = null)
    {
        $this->orderData = $orderData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Order
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
