<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerData StructType
 * @subpackage Structs
 */
class CustomerData extends AbstractStructBase
{
    /**
     * The magentoId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $magentoId;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $title;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 40
     * - minLength: 1
     * @var string
     */
    public $lastName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 40
     * - minLength: 1
     * @var string
     */
    public $firstName;
    /**
     * The custGroup
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 40
     * - minLength: 1
     * @var string
     */
    public $custGroup;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 1
     * @var string
     */
    public $language;
    /**
     * The mail
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $mail;
    /**
     * The taxNr
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 18
     * - minLength: 1
     * @var string
     */
    public $taxNr;
    /**
     * The company
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 150
     * - minLength: 1
     * @var string
     */
    public $company;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $phone;
    /**
     * The sapCustNr
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $sapCustNr;
    /**
     * The sapCustGr3
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $sapCustGr3;
    /**
     * The sapCustGr4
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $sapCustGr4;
    /**
     * Constructor method for customerData
     * @uses CustomerData::setMagentoId()
     * @uses CustomerData::setTitle()
     * @uses CustomerData::setLastName()
     * @uses CustomerData::setFirstName()
     * @uses CustomerData::setCustGroup()
     * @uses CustomerData::setCountry()
     * @uses CustomerData::setLanguage()
     * @uses CustomerData::setMail()
     * @uses CustomerData::setTaxNr()
     * @uses CustomerData::setCompany()
     * @uses CustomerData::setPhone()
     * @uses CustomerData::setSapCustNr()
     * @uses CustomerData::setSapCustGr3()
     * @uses CustomerData::setSapCustGr4()
     * @param string $magentoId
     * @param string $title
     * @param string $lastName
     * @param string $firstName
     * @param string $custGroup
     * @param string $country
     * @param string $language
     * @param string $mail
     * @param string $taxNr
     * @param string $company
     * @param string $phone
     * @param string $sapCustNr
     * @param string $sapCustGr3
     * @param string $sapCustGr4
     */
    public function __construct($magentoId = null, $title = null, $lastName = null, $firstName = null, $custGroup = null, $country = null, $language = null, $mail = null, $taxNr = null, $company = null, $phone = null, $sapCustNr = null, $sapCustGr3 = null, $sapCustGr4 = null)
    {
        $this
            ->setMagentoId($magentoId)
            ->setTitle($title)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setCustGroup($custGroup)
            ->setCountry($country)
            ->setLanguage($language)
            ->setMail($mail)
            ->setTaxNr($taxNr)
            ->setCompany($company)
            ->setPhone($phone)
            ->setSapCustNr($sapCustNr)
            ->setSapCustGr3($sapCustGr3)
            ->setSapCustGr4($sapCustGr4);
    }
    /**
     * Get magentoId value
     * @return string|null
     */
    public function getMagentoId()
    {
        return $this->magentoId;
    }
    /**
     * Set magentoId value
     * @param string $magentoId
     * @return \StructType\CustomerData
     */
    public function setMagentoId($magentoId = null)
    {
        // validation for constraint: string
        if (!is_null($magentoId) && !is_string($magentoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($magentoId, true), gettype($magentoId)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($magentoId) && mb_strlen($magentoId) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($magentoId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($magentoId) && mb_strlen($magentoId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($magentoId)), __LINE__);
        }
        $this->magentoId = $magentoId;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\CustomerData
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($title) && mb_strlen($title) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($title)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($title) && mb_strlen($title) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\CustomerData
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($lastName) && mb_strlen($lastName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($lastName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lastName) && mb_strlen($lastName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\CustomerData
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($firstName) && mb_strlen($firstName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($firstName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($firstName) && mb_strlen($firstName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get custGroup value
     * @return string|null
     */
    public function getCustGroup()
    {
        return $this->custGroup;
    }
    /**
     * Set custGroup value
     * @param string $custGroup
     * @return \StructType\CustomerData
     */
    public function setCustGroup($custGroup = null)
    {
        // validation for constraint: string
        if (!is_null($custGroup) && !is_string($custGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custGroup, true), gettype($custGroup)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($custGroup) && mb_strlen($custGroup) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($custGroup)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($custGroup) && mb_strlen($custGroup) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($custGroup)), __LINE__);
        }
        $this->custGroup = $custGroup;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\CustomerData
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($country) && mb_strlen($country) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($country)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($country) && mb_strlen($country) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\CustomerData
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($language) && mb_strlen($language) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($language)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($language) && mb_strlen($language) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->mail;
    }
    /**
     * Set mail value
     * @param string $mail
     * @return \StructType\CustomerData
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($mail) && mb_strlen($mail) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($mail)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($mail) && mb_strlen($mail) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($mail)), __LINE__);
        }
        $this->mail = $mail;
        return $this;
    }
    /**
     * Get taxNr value
     * @return string|null
     */
    public function getTaxNr()
    {
        return $this->taxNr;
    }
    /**
     * Set taxNr value
     * @param string $taxNr
     * @return \StructType\CustomerData
     */
    public function setTaxNr($taxNr = null)
    {
        // validation for constraint: string
        if (!is_null($taxNr) && !is_string($taxNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxNr, true), gettype($taxNr)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($taxNr) && mb_strlen($taxNr) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($taxNr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taxNr) && mb_strlen($taxNr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taxNr)), __LINE__);
        }
        $this->taxNr = $taxNr;
        return $this;
    }
    /**
     * Get company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \StructType\CustomerData
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        // validation for constraint: maxLength(150)
        if (!is_null($company) && mb_strlen($company) > 150) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 150', mb_strlen($company)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($company) && mb_strlen($company) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\CustomerData
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone) && mb_strlen($phone) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($phone) && mb_strlen($phone) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get sapCustNr value
     * @return string|null
     */
    public function getSapCustNr()
    {
        return $this->sapCustNr;
    }
    /**
     * Set sapCustNr value
     * @param string $sapCustNr
     * @return \StructType\CustomerData
     */
    public function setSapCustNr($sapCustNr = null)
    {
        // validation for constraint: string
        if (!is_null($sapCustNr) && !is_string($sapCustNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sapCustNr, true), gettype($sapCustNr)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($sapCustNr) && mb_strlen($sapCustNr) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($sapCustNr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($sapCustNr) && mb_strlen($sapCustNr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($sapCustNr)), __LINE__);
        }
        $this->sapCustNr = $sapCustNr;
        return $this;
    }
    /**
     * Get sapCustGr3 value
     * @return string|null
     */
    public function getSapCustGr3()
    {
        return $this->sapCustGr3;
    }
    /**
     * Set sapCustGr3 value
     * @param string $sapCustGr3
     * @return \StructType\CustomerData
     */
    public function setSapCustGr3($sapCustGr3 = null)
    {
        // validation for constraint: string
        if (!is_null($sapCustGr3) && !is_string($sapCustGr3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sapCustGr3, true), gettype($sapCustGr3)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($sapCustGr3) && mb_strlen($sapCustGr3) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($sapCustGr3)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($sapCustGr3) && mb_strlen($sapCustGr3) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($sapCustGr3)), __LINE__);
        }
        $this->sapCustGr3 = $sapCustGr3;
        return $this;
    }
    /**
     * Get sapCustGr4 value
     * @return string|null
     */
    public function getSapCustGr4()
    {
        return $this->sapCustGr4;
    }
    /**
     * Set sapCustGr4 value
     * @param string $sapCustGr4
     * @return \StructType\CustomerData
     */
    public function setSapCustGr4($sapCustGr4 = null)
    {
        // validation for constraint: string
        if (!is_null($sapCustGr4) && !is_string($sapCustGr4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sapCustGr4, true), gettype($sapCustGr4)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($sapCustGr4) && mb_strlen($sapCustGr4) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($sapCustGr4)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($sapCustGr4) && mb_strlen($sapCustGr4) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($sapCustGr4)), __LINE__);
        }
        $this->sapCustGr4 = $sapCustGr4;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
