<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LanguageName StructType
 * @subpackage Structs
 */
class LanguageName extends AbstractStructBase
{
    /**
     * The sISOCode
     * @var string
     */
    public $sISOCode;
    /**
     * Constructor method for LanguageName
     * @uses LanguageName::setSISOCode()
     * @param string $sISOCode
     */
    public function __construct($sISOCode = null)
    {
        $this
            ->setSISOCode($sISOCode);
    }
    /**
     * Get sISOCode value
     * @return string|null
     */
    public function getSISOCode()
    {
        return $this->sISOCode;
    }
    /**
     * Set sISOCode value
     * @param string $sISOCode
     * @return \StructType\LanguageName
     */
    public function setSISOCode($sISOCode = null)
    {
        // validation for constraint: string
        if (!is_null($sISOCode) && !is_string($sISOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sISOCode, true), gettype($sISOCode)), __LINE__);
        }
        $this->sISOCode = $sISOCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LanguageName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
