<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyName StructType
 * @subpackage Structs
 */
class CurrencyName extends AbstractStructBase
{
    /**
     * The sCurrencyISOCode
     * @var string
     */
    public $sCurrencyISOCode;
    /**
     * Constructor method for CurrencyName
     * @uses CurrencyName::setSCurrencyISOCode()
     * @param string $sCurrencyISOCode
     */
    public function __construct($sCurrencyISOCode = null)
    {
        $this
            ->setSCurrencyISOCode($sCurrencyISOCode);
    }
    /**
     * Get sCurrencyISOCode value
     * @return string|null
     */
    public function getSCurrencyISOCode()
    {
        return $this->sCurrencyISOCode;
    }
    /**
     * Set sCurrencyISOCode value
     * @param string $sCurrencyISOCode
     * @return \StructType\CurrencyName
     */
    public function setSCurrencyISOCode($sCurrencyISOCode = null)
    {
        // validation for constraint: string
        if (!is_null($sCurrencyISOCode) && !is_string($sCurrencyISOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sCurrencyISOCode, true), gettype($sCurrencyISOCode)), __LINE__);
        }
        $this->sCurrencyISOCode = $sCurrencyISOCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CurrencyName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
