<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListOfContinentsByName
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of continents ordered by name.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListOfContinentsByName $parameters
     * @return \StructType\ListOfContinentsByNameResponse|bool
     */
    public function ListOfContinentsByName(\StructType\ListOfContinentsByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfContinentsByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfContinentsByCode
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of continents ordered by code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListOfContinentsByCode $parameters
     * @return \StructType\ListOfContinentsByCodeResponse|bool
     */
    public function ListOfContinentsByCode(\StructType\ListOfContinentsByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfContinentsByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfCurrenciesByName
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of currencies ordered by name.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListOfCurrenciesByName $parameters
     * @return \StructType\ListOfCurrenciesByNameResponse|bool
     */
    public function ListOfCurrenciesByName(\StructType\ListOfCurrenciesByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfCurrenciesByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfCurrenciesByCode
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of currencies ordered by code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListOfCurrenciesByCode $parameters
     * @return \StructType\ListOfCurrenciesByCodeResponse|bool
     */
    public function ListOfCurrenciesByCode(\StructType\ListOfCurrenciesByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfCurrenciesByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfCountryNamesByCode
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of all stored counties ordered by ISO code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListOfCountryNamesByCode $parameters
     * @return \StructType\ListOfCountryNamesByCodeResponse|bool
     */
    public function ListOfCountryNamesByCode(\StructType\ListOfCountryNamesByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfCountryNamesByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfCountryNamesByName
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of all stored counties ordered by country name
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListOfCountryNamesByName $parameters
     * @return \StructType\ListOfCountryNamesByNameResponse|bool
     */
    public function ListOfCountryNamesByName(\StructType\ListOfCountryNamesByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfCountryNamesByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListOfCountryNamesGroupedByContinent
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of all stored counties grouped per continent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListOfCountryNamesGroupedByContinent $parameters
     * @return \StructType\ListOfCountryNamesGroupedByContinentResponse|bool
     */
    public function ListOfCountryNamesGroupedByContinent(\StructType\ListOfCountryNamesGroupedByContinent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfCountryNamesGroupedByContinent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfLanguagesByName
     * Meta information extracted from the WSDL
     * - documentation: Returns an array of languages ordered by name
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListOfLanguagesByName $parameters
     * @return \StructType\ListOfLanguagesByNameResponse|bool
     */
    public function ListOfLanguagesByName(\StructType\ListOfLanguagesByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfLanguagesByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListOfLanguagesByCode
     * Meta information extracted from the WSDL
     * - documentation: Returns an array of languages ordered by code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListOfLanguagesByCode $parameters
     * @return \StructType\ListOfLanguagesByCodeResponse|bool
     */
    public function ListOfLanguagesByCode(\StructType\ListOfLanguagesByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListOfLanguagesByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListOfContinentsByCodeResponse|\StructType\ListOfContinentsByNameResponse|\StructType\ListOfCountryNamesByCodeResponse|\StructType\ListOfCountryNamesByNameResponse|\StructType\ListOfCountryNamesGroupedByContinentResponse|\StructType\ListOfCurrenciesByCodeResponse|\StructType\ListOfCurrenciesByNameResponse|\StructType\ListOfLanguagesByCodeResponse|\StructType\ListOfLanguagesByNameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
