<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Full ServiceType
 * @subpackage Services
 */
class Full extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FullCountryInfo
     * Meta information extracted from the WSDL
     * - documentation: Returns a struct with all the stored country information. Pass the ISO country code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FullCountryInfo $parameters
     * @return \StructType\FullCountryInfoResponse|bool
     */
    public function FullCountryInfo(\StructType\FullCountryInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FullCountryInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FullCountryInfoAllCountries
     * Meta information extracted from the WSDL
     * - documentation: Returns an array with all countries and all the language information stored
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FullCountryInfoAllCountries $parameters
     * @return \StructType\FullCountryInfoAllCountriesResponse|bool
     */
    public function FullCountryInfoAllCountries(\StructType\FullCountryInfoAllCountries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FullCountryInfoAllCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FullCountryInfoAllCountriesResponse|\StructType\FullCountryInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
