<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Country ServiceType
 * @subpackage Services
 */
class Country extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CountryName
     * Meta information extracted from the WSDL
     * - documentation: Searches the database for a country by the passed ISO country code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CountryName $parameters
     * @return \StructType\CountryNameResponse|bool
     */
    public function CountryName(\StructType\CountryName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CountryName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CountryISOCode
     * Meta information extracted from the WSDL
     * - documentation: This function tries to found a country based on the passed country name.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CountryISOCode $parameters
     * @return \StructType\CountryISOCodeResponse|bool
     */
    public function CountryISOCode(\StructType\CountryISOCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CountryISOCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CountryCurrency
     * Meta information extracted from the WSDL
     * - documentation: Returns the currency ISO code and name for the passed country ISO code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CountryCurrency $parameters
     * @return \StructType\CountryCurrencyResponse|bool
     */
    public function CountryCurrency(\StructType\CountryCurrency $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CountryCurrency($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CountryFlag
     * Meta information extracted from the WSDL
     * - documentation: Returns a link to a picture of the country flag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CountryFlag $parameters
     * @return \StructType\CountryFlagResponse|bool
     */
    public function CountryFlag(\StructType\CountryFlag $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CountryFlag($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CountryIntPhoneCode
     * Meta information extracted from the WSDL
     * - documentation: Returns the internation phone code for the passed ISO country code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CountryIntPhoneCode $parameters
     * @return \StructType\CountryIntPhoneCodeResponse|bool
     */
    public function CountryIntPhoneCode(\StructType\CountryIntPhoneCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CountryIntPhoneCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CountryCurrencyResponse|\StructType\CountryFlagResponse|\StructType\CountryIntPhoneCodeResponse|\StructType\CountryISOCodeResponse|\StructType\CountryNameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
