<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Capital ServiceType
 * @subpackage Services
 */
class Capital extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CapitalCity
     * Meta information extracted from the WSDL
     * - documentation: Returns the name of the captial city for the passed country code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CapitalCity $parameters
     * @return \StructType\CapitalCityResponse|bool
     */
    public function CapitalCity(\StructType\CapitalCity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CapitalCity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CapitalCityResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
