<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractUpgrade StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ContractUpgrade
 * @subpackage Structs
 */
class ContractUpgrade extends AbstractStructBase
{
    /**
     * The BusinessPhoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessPhoneNumber;
    /**
     * The CellNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CellNumber;
    /**
     * The ContractNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractNumber;
    /**
     * The EMailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EMailAddress;
    /**
     * The SubscriberName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriberName;
    /**
     * The Vehicles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfVehicleContractUpgrade
     */
    public $Vehicles;
    /**
     * Constructor method for ContractUpgrade
     * @uses ContractUpgrade::setBusinessPhoneNumber()
     * @uses ContractUpgrade::setCellNumber()
     * @uses ContractUpgrade::setContractNumber()
     * @uses ContractUpgrade::setEMailAddress()
     * @uses ContractUpgrade::setSubscriberName()
     * @uses ContractUpgrade::setVehicles()
     * @param string $businessPhoneNumber
     * @param string $cellNumber
     * @param string $contractNumber
     * @param string $eMailAddress
     * @param string $subscriberName
     * @param \ArrayType\ArrayOfVehicleContractUpgrade $vehicles
     */
    public function __construct($businessPhoneNumber = null, $cellNumber = null, $contractNumber = null, $eMailAddress = null, $subscriberName = null, \ArrayType\ArrayOfVehicleContractUpgrade $vehicles = null)
    {
        $this
            ->setBusinessPhoneNumber($businessPhoneNumber)
            ->setCellNumber($cellNumber)
            ->setContractNumber($contractNumber)
            ->setEMailAddress($eMailAddress)
            ->setSubscriberName($subscriberName)
            ->setVehicles($vehicles);
    }
    /**
     * Get BusinessPhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessPhoneNumber()
    {
        return isset($this->BusinessPhoneNumber) ? $this->BusinessPhoneNumber : null;
    }
    /**
     * Set BusinessPhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessPhoneNumber
     * @return \StructType\ContractUpgrade
     */
    public function setBusinessPhoneNumber($businessPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($businessPhoneNumber) && !is_string($businessPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($businessPhoneNumber)), __LINE__);
        }
        if (is_null($businessPhoneNumber) || (is_array($businessPhoneNumber) && empty($businessPhoneNumber))) {
            unset($this->BusinessPhoneNumber);
        } else {
            $this->BusinessPhoneNumber = $businessPhoneNumber;
        }
        return $this;
    }
    /**
     * Get CellNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCellNumber()
    {
        return isset($this->CellNumber) ? $this->CellNumber : null;
    }
    /**
     * Set CellNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cellNumber
     * @return \StructType\ContractUpgrade
     */
    public function setCellNumber($cellNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cellNumber) && !is_string($cellNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cellNumber)), __LINE__);
        }
        if (is_null($cellNumber) || (is_array($cellNumber) && empty($cellNumber))) {
            unset($this->CellNumber);
        } else {
            $this->CellNumber = $cellNumber;
        }
        return $this;
    }
    /**
     * Get ContractNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractNumber()
    {
        return isset($this->ContractNumber) ? $this->ContractNumber : null;
    }
    /**
     * Set ContractNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractNumber
     * @return \StructType\ContractUpgrade
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractNumber)), __LINE__);
        }
        if (is_null($contractNumber) || (is_array($contractNumber) && empty($contractNumber))) {
            unset($this->ContractNumber);
        } else {
            $this->ContractNumber = $contractNumber;
        }
        return $this;
    }
    /**
     * Get EMailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEMailAddress()
    {
        return isset($this->EMailAddress) ? $this->EMailAddress : null;
    }
    /**
     * Set EMailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eMailAddress
     * @return \StructType\ContractUpgrade
     */
    public function setEMailAddress($eMailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($eMailAddress) && !is_string($eMailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eMailAddress)), __LINE__);
        }
        if (is_null($eMailAddress) || (is_array($eMailAddress) && empty($eMailAddress))) {
            unset($this->EMailAddress);
        } else {
            $this->EMailAddress = $eMailAddress;
        }
        return $this;
    }
    /**
     * Get SubscriberName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberName()
    {
        return isset($this->SubscriberName) ? $this->SubscriberName : null;
    }
    /**
     * Set SubscriberName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberName
     * @return \StructType\ContractUpgrade
     */
    public function setSubscriberName($subscriberName = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberName) && !is_string($subscriberName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberName)), __LINE__);
        }
        if (is_null($subscriberName) || (is_array($subscriberName) && empty($subscriberName))) {
            unset($this->SubscriberName);
        } else {
            $this->SubscriberName = $subscriberName;
        }
        return $this;
    }
    /**
     * Get Vehicles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfVehicleContractUpgrade|null
     */
    public function getVehicles()
    {
        return isset($this->Vehicles) ? $this->Vehicles : null;
    }
    /**
     * Set Vehicles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfVehicleContractUpgrade $vehicles
     * @return \StructType\ContractUpgrade
     */
    public function setVehicles(\ArrayType\ArrayOfVehicleContractUpgrade $vehicles = null)
    {
        if (is_null($vehicles) || (is_array($vehicles) && empty($vehicles))) {
            unset($this->Vehicles);
        } else {
            $this->Vehicles = $vehicles;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContractUpgrade
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
