<?php

namespace EnumType;

/**
 * This class stands for an_VehicleType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:an_VehicleType
 * @subpackage Enumerations
 */
class An_VehicleType
{
    /**
     * Constant for value 'Passenger'
     * @return string 'Passenger'
     */
    const VALUE_PASSENGER = 'Passenger';
    /**
     * Constant for value 'Commercial'
     * @return string 'Commercial'
     */
    const VALUE_COMMERCIAL = 'Commercial';
    /**
     * Constant for value 'Construction'
     * @return string 'Construction'
     */
    const VALUE_CONSTRUCTION = 'Construction';
    /**
     * Constant for value 'Trailer'
     * @return string 'Trailer'
     */
    const VALUE_TRAILER = 'Trailer';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PASSENGER
     * @uses self::VALUE_COMMERCIAL
     * @uses self::VALUE_CONSTRUCTION
     * @uses self::VALUE_TRAILER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PASSENGER,
            self::VALUE_COMMERCIAL,
            self::VALUE_CONSTRUCTION,
            self::VALUE_TRAILER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
