<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUnitType ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfUnitType
 * @subpackage Arrays
 */
class ArrayOfUnitType extends AbstractStructArrayBase
{
    /**
     * The UnitType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UnitType[]
     */
    public $UnitType;
    /**
     * Constructor method for ArrayOfUnitType
     * @uses ArrayOfUnitType::setUnitType()
     * @param \StructType\UnitType[] $unitType
     */
    public function __construct(array $unitType = array())
    {
        $this
            ->setUnitType($unitType);
    }
    /**
     * Get UnitType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UnitType[]|null
     */
    public function getUnitType()
    {
        return isset($this->UnitType) ? $this->UnitType : null;
    }
    /**
     * Set UnitType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UnitType[] $unitType
     * @return \ArrayType\ArrayOfUnitType
     */
    public function setUnitType(array $unitType = array())
    {
        foreach ($unitType as $arrayOfUnitTypeUnitTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfUnitTypeUnitTypeItem instanceof \StructType\UnitType) {
                throw new \InvalidArgumentException(sprintf('The UnitType property can only contain items of \StructType\UnitType, "%s" given', is_object($arrayOfUnitTypeUnitTypeItem) ? get_class($arrayOfUnitTypeUnitTypeItem) : gettype($arrayOfUnitTypeUnitTypeItem)), __LINE__);
            }
        }
        if (is_null($unitType) || (is_array($unitType) && empty($unitType))) {
            unset($this->UnitType);
        } else {
            $this->UnitType = $unitType;
        }
        return $this;
    }
    /**
     * Add item to UnitType value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitType $item
     * @return \ArrayType\ArrayOfUnitType
     */
    public function addToUnitType(\StructType\UnitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitType) {
            throw new \InvalidArgumentException(sprintf('The UnitType property can only contain items of \StructType\UnitType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnitType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\UnitType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\UnitType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\UnitType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\UnitType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\UnitType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UnitType
     */
    public function getAttributeName()
    {
        return 'UnitType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfUnitType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
