<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for an_PLPLead StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:an_PLPLead
 * @subpackage Structs
 */
class An_PLPLead extends AbstractStructBase
{
    /**
     * The CurrentContractNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentContractNumber;
    /**
     * The DealOption
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DealOption
     */
    public $DealOption;
    /**
     * The PartnerRefId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PartnerRefId;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Vehicle
     */
    public $Vehicle;
    /**
     * Constructor method for an_PLPLead
     * @uses An_PLPLead::setCurrentContractNumber()
     * @uses An_PLPLead::setDealOption()
     * @uses An_PLPLead::setPartnerRefId()
     * @uses An_PLPLead::setVehicle()
     * @param string $currentContractNumber
     * @param \StructType\DealOption $dealOption
     * @param int $partnerRefId
     * @param \StructType\Vehicle $vehicle
     */
    public function __construct($currentContractNumber = null, \StructType\DealOption $dealOption = null, $partnerRefId = null, \StructType\Vehicle $vehicle = null)
    {
        $this
            ->setCurrentContractNumber($currentContractNumber)
            ->setDealOption($dealOption)
            ->setPartnerRefId($partnerRefId)
            ->setVehicle($vehicle);
    }
    /**
     * Get CurrentContractNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentContractNumber()
    {
        return isset($this->CurrentContractNumber) ? $this->CurrentContractNumber : null;
    }
    /**
     * Set CurrentContractNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentContractNumber
     * @return \StructType\An_PLPLead
     */
    public function setCurrentContractNumber($currentContractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($currentContractNumber) && !is_string($currentContractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentContractNumber)), __LINE__);
        }
        if (is_null($currentContractNumber) || (is_array($currentContractNumber) && empty($currentContractNumber))) {
            unset($this->CurrentContractNumber);
        } else {
            $this->CurrentContractNumber = $currentContractNumber;
        }
        return $this;
    }
    /**
     * Get DealOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DealOption|null
     */
    public function getDealOption()
    {
        return isset($this->DealOption) ? $this->DealOption : null;
    }
    /**
     * Set DealOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DealOption $dealOption
     * @return \StructType\An_PLPLead
     */
    public function setDealOption(\StructType\DealOption $dealOption = null)
    {
        if (is_null($dealOption) || (is_array($dealOption) && empty($dealOption))) {
            unset($this->DealOption);
        } else {
            $this->DealOption = $dealOption;
        }
        return $this;
    }
    /**
     * Get PartnerRefId value
     * @return int|null
     */
    public function getPartnerRefId()
    {
        return $this->PartnerRefId;
    }
    /**
     * Set PartnerRefId value
     * @param int $partnerRefId
     * @return \StructType\An_PLPLead
     */
    public function setPartnerRefId($partnerRefId = null)
    {
        // validation for constraint: int
        if (!is_null($partnerRefId) && !is_numeric($partnerRefId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partnerRefId)), __LINE__);
        }
        $this->PartnerRefId = $partnerRefId;
        return $this;
    }
    /**
     * Get Vehicle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Vehicle|null
     */
    public function getVehicle()
    {
        return isset($this->Vehicle) ? $this->Vehicle : null;
    }
    /**
     * Set Vehicle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Vehicle $vehicle
     * @return \StructType\An_PLPLead
     */
    public function setVehicle(\StructType\Vehicle $vehicle = null)
    {
        if (is_null($vehicle) || (is_array($vehicle) && empty($vehicle))) {
            unset($this->Vehicle);
        } else {
            $this->Vehicle = $vehicle;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\An_PLPLead
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
