<?php

namespace EnumType;

/**
 * This class stands for an_VehicleFuelType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:an_VehicleFuelType
 * @subpackage Enumerations
 */
class An_VehicleFuelType
{
    /**
     * Constant for value 'Petrol'
     * @return string 'Petrol'
     */
    const VALUE_PETROL = 'Petrol';
    /**
     * Constant for value 'Diesel'
     * @return string 'Diesel'
     */
    const VALUE_DIESEL = 'Diesel';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PETROL
     * @uses self::VALUE_DIESEL
     * @uses self::VALUE_NONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PETROL,
            self::VALUE_DIESEL,
            self::VALUE_NONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
