<?php

namespace EnumType;

/**
 * This class stands for an_RelationType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:an_RelationType
 * @subpackage Enumerations
 */
class An_RelationType
{
    /**
     * Constant for value 'PrimaryContact'
     * @return string 'PrimaryContact'
     */
    const VALUE_PRIMARY_CONTACT = 'PrimaryContact';
    /**
     * Constant for value 'SecondaryContact'
     * @return string 'SecondaryContact'
     */
    const VALUE_SECONDARY_CONTACT = 'SecondaryContact';
    /**
     * Constant for value 'ThirdContact'
     * @return string 'ThirdContact'
     */
    const VALUE_THIRD_CONTACT = 'ThirdContact';
    /**
     * Constant for value 'FourthContact'
     * @return string 'FourthContact'
     */
    const VALUE_FOURTH_CONTACT = 'FourthContact';
    /**
     * Constant for value 'FifthContact'
     * @return string 'FifthContact'
     */
    const VALUE_FIFTH_CONTACT = 'FifthContact';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRIMARY_CONTACT
     * @uses self::VALUE_SECONDARY_CONTACT
     * @uses self::VALUE_THIRD_CONTACT
     * @uses self::VALUE_FOURTH_CONTACT
     * @uses self::VALUE_FIFTH_CONTACT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRIMARY_CONTACT,
            self::VALUE_SECONDARY_CONTACT,
            self::VALUE_THIRD_CONTACT,
            self::VALUE_FOURTH_CONTACT,
            self::VALUE_FIFTH_CONTACT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
