<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://41.220.65.180:8080/axis2/services/NIPProxy2?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://41.220.65.180:8080/axis2/services/NIPProxy2?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Tsq ServiceType
 */
$tsq = new \ServiceType\Tsq($options);
/**
 * Sample call for tsq operation/method
 */
if ($tsq->tsq(new \StructType\Tsq()) !== false) {
    print_r($tsq->getResult());
} else {
    print_r($tsq->getLastError());
}
/**
 * Samples for Ne ServiceType
 */
$ne = new \ServiceType\Ne($options);
/**
 * Sample call for ne operation/method
 */
if ($ne->ne(new \StructType\Ne()) !== false) {
    print_r($ne->getResult());
} else {
    print_r($ne->getLastError());
}
/**
 * Samples for Reload ServiceType
 */
$reload = new \ServiceType\Reload($options);
/**
 * Sample call for reloadConfig operation/method
 */
if ($reload->reloadConfig(new \StructType\ReloadConfig()) !== false) {
    print_r($reload->getResult());
} else {
    print_r($reload->getLastError());
}
/**
 * Samples for Gen ServiceType
 */
$gen = new \ServiceType\Gen($options);
/**
 * Sample call for genKey operation/method
 */
if ($gen->genKey(new \StructType\GenKey()) !== false) {
    print_r($gen->getResult());
} else {
    print_r($gen->getLastError());
}
/**
 * Samples for Ft ServiceType
 */
$ft = new \ServiceType\Ft($options);
/**
 * Sample call for ft operation/method
 */
if ($ft->ft(new \StructType\Ft()) !== false) {
    print_r($ft->getResult());
} else {
    print_r($ft->getLastError());
}
