<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ft StructType
 * @subpackage Structs
 */
class Ft extends AbstractStructBase
{
    /**
     * The apiUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $apiUser;
    /**
     * The request
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $request;
    /**
     * The hash
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $hash;
    /**
     * Constructor method for ft
     * @uses Ft::setApiUser()
     * @uses Ft::setRequest()
     * @uses Ft::setHash()
     * @param string $apiUser
     * @param string $request
     * @param string $hash
     */
    public function __construct($apiUser = null, $request = null, $hash = null)
    {
        $this
            ->setApiUser($apiUser)
            ->setRequest($request)
            ->setHash($hash);
    }
    /**
     * Get apiUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiUser()
    {
        return isset($this->apiUser) ? $this->apiUser : null;
    }
    /**
     * Set apiUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiUser
     * @return \StructType\Ft
     */
    public function setApiUser($apiUser = null)
    {
        // validation for constraint: string
        if (!is_null($apiUser) && !is_string($apiUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiUser, true), gettype($apiUser)), __LINE__);
        }
        if (is_null($apiUser) || (is_array($apiUser) && empty($apiUser))) {
            unset($this->apiUser);
        } else {
            $this->apiUser = $apiUser;
        }
        return $this;
    }
    /**
     * Get request value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequest()
    {
        return isset($this->request) ? $this->request : null;
    }
    /**
     * Set request value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $request
     * @return \StructType\Ft
     */
    public function setRequest($request = null)
    {
        // validation for constraint: string
        if (!is_null($request) && !is_string($request)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request, true), gettype($request)), __LINE__);
        }
        if (is_null($request) || (is_array($request) && empty($request))) {
            unset($this->request);
        } else {
            $this->request = $request;
        }
        return $this;
    }
    /**
     * Get hash value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHash()
    {
        return isset($this->hash) ? $this->hash : null;
    }
    /**
     * Set hash value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hash
     * @return \StructType\Ft
     */
    public function setHash($hash = null)
    {
        // validation for constraint: string
        if (!is_null($hash) && !is_string($hash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hash, true), gettype($hash)), __LINE__);
        }
        if (is_null($hash) || (is_array($hash) && empty($hash))) {
            unset($this->hash);
        } else {
            $this->hash = $hash;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ft
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
