<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reload ServiceType
 * @subpackage Services
 */
class Reload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named reloadConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReloadConfig $parameters
     * @return \StructType\ReloadConfigResponse|bool
     */
    public function reloadConfig(\StructType\ReloadConfig $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->reloadConfig($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReloadConfigResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
