<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for SISECQMISS ServiceType
 * @subpackage Services
 */
class SISECQMISS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SI_SEC_QMIS_Survey_OA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DT_QMIS_Survey $mT_QMIS_Survey
     * @return void|bool
     */
    public function SI_SEC_QMIS_Survey_OA(\StructType\DT_QMIS_Survey $mT_QMIS_Survey)
    {
        try {
            $this->setResult($this->getSoapClient()->SI_SEC_QMIS_Survey_OA($mT_QMIS_Survey));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
