<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WithDrawalBranchTransfer StructType
 * @subpackage Structs
 */
class WithDrawalBranchTransfer extends AbstractStructBase
{
    /**
     * The branchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $branchId;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $amount;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The walletCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $walletCode;
    /**
     * The amount2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $amount2;
    /**
     * Constructor method for WithDrawalBranchTransfer
     * @uses WithDrawalBranchTransfer::setBranchId()
     * @uses WithDrawalBranchTransfer::setAmount()
     * @uses WithDrawalBranchTransfer::setTokenId()
     * @uses WithDrawalBranchTransfer::setWalletCode()
     * @uses WithDrawalBranchTransfer::setAmount2()
     * @param int $branchId
     * @param int $amount
     * @param string $tokenId
     * @param string $walletCode
     * @param string $amount2
     */
    public function __construct($branchId = null, $amount = null, $tokenId = null, $walletCode = null, $amount2 = null)
    {
        $this
            ->setBranchId($branchId)
            ->setAmount($amount)
            ->setTokenId($tokenId)
            ->setWalletCode($walletCode)
            ->setAmount2($amount2);
    }
    /**
     * Get branchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->branchId;
    }
    /**
     * Set branchId value
     * @param int $branchId
     * @return \StructType\WithDrawalBranchTransfer
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->branchId = $branchId;
        return $this;
    }
    /**
     * Get amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\WithDrawalBranchTransfer
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\WithDrawalBranchTransfer
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get walletCode value
     * @return string|null
     */
    public function getWalletCode()
    {
        return $this->walletCode;
    }
    /**
     * Set walletCode value
     * @param string $walletCode
     * @return \StructType\WithDrawalBranchTransfer
     */
    public function setWalletCode($walletCode = null)
    {
        // validation for constraint: string
        if (!is_null($walletCode) && !is_string($walletCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletCode, true), gettype($walletCode)), __LINE__);
        }
        $this->walletCode = $walletCode;
        return $this;
    }
    /**
     * Get amount2 value
     * @return string|null
     */
    public function getAmount2()
    {
        return $this->amount2;
    }
    /**
     * Set amount2 value
     * @param string $amount2
     * @return \StructType\WithDrawalBranchTransfer
     */
    public function setAmount2($amount2 = null)
    {
        // validation for constraint: string
        if (!is_null($amount2) && !is_string($amount2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount2, true), gettype($amount2)), __LINE__);
        }
        $this->amount2 = $amount2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WithDrawalBranchTransfer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
