<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WalletTransfer StructType
 * @subpackage Structs
 */
class WalletTransfer extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $amount;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The fromWallet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fromWallet;
    /**
     * The toWallet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $toWallet;
    /**
     * The amount2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $amount2;
    /**
     * Constructor method for WalletTransfer
     * @uses WalletTransfer::setAmount()
     * @uses WalletTransfer::setTokenId()
     * @uses WalletTransfer::setFromWallet()
     * @uses WalletTransfer::setToWallet()
     * @uses WalletTransfer::setAmount2()
     * @param int $amount
     * @param string $tokenId
     * @param string $fromWallet
     * @param string $toWallet
     * @param string $amount2
     */
    public function __construct($amount = null, $tokenId = null, $fromWallet = null, $toWallet = null, $amount2 = null)
    {
        $this
            ->setAmount($amount)
            ->setTokenId($tokenId)
            ->setFromWallet($fromWallet)
            ->setToWallet($toWallet)
            ->setAmount2($amount2);
    }
    /**
     * Get amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\WalletTransfer
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\WalletTransfer
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get fromWallet value
     * @return string|null
     */
    public function getFromWallet()
    {
        return $this->fromWallet;
    }
    /**
     * Set fromWallet value
     * @param string $fromWallet
     * @return \StructType\WalletTransfer
     */
    public function setFromWallet($fromWallet = null)
    {
        // validation for constraint: string
        if (!is_null($fromWallet) && !is_string($fromWallet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromWallet, true), gettype($fromWallet)), __LINE__);
        }
        $this->fromWallet = $fromWallet;
        return $this;
    }
    /**
     * Get toWallet value
     * @return string|null
     */
    public function getToWallet()
    {
        return $this->toWallet;
    }
    /**
     * Set toWallet value
     * @param string $toWallet
     * @return \StructType\WalletTransfer
     */
    public function setToWallet($toWallet = null)
    {
        // validation for constraint: string
        if (!is_null($toWallet) && !is_string($toWallet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toWallet, true), gettype($toWallet)), __LINE__);
        }
        $this->toWallet = $toWallet;
        return $this;
    }
    /**
     * Get amount2 value
     * @return string|null
     */
    public function getAmount2()
    {
        return $this->amount2;
    }
    /**
     * Set amount2 value
     * @param string $amount2
     * @return \StructType\WalletTransfer
     */
    public function setAmount2($amount2 = null)
    {
        // validation for constraint: string
        if (!is_null($amount2) && !is_string($amount2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount2, true), gettype($amount2)), __LINE__);
        }
        $this->amount2 = $amount2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WalletTransfer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
