<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateMailActivation StructType
 * @subpackage Structs
 */
class ValidateMailActivation extends AbstractStructBase
{
    /**
     * The accountTokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountTokenId;
    /**
     * The mailTokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailTokenId;
    /**
     * The activationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $activationCode;
    /**
     * Constructor method for ValidateMailActivation
     * @uses ValidateMailActivation::setAccountTokenId()
     * @uses ValidateMailActivation::setMailTokenId()
     * @uses ValidateMailActivation::setActivationCode()
     * @param string $accountTokenId
     * @param string $mailTokenId
     * @param string $activationCode
     */
    public function __construct($accountTokenId = null, $mailTokenId = null, $activationCode = null)
    {
        $this
            ->setAccountTokenId($accountTokenId)
            ->setMailTokenId($mailTokenId)
            ->setActivationCode($activationCode);
    }
    /**
     * Get accountTokenId value
     * @return string|null
     */
    public function getAccountTokenId()
    {
        return $this->accountTokenId;
    }
    /**
     * Set accountTokenId value
     * @param string $accountTokenId
     * @return \StructType\ValidateMailActivation
     */
    public function setAccountTokenId($accountTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($accountTokenId) && !is_string($accountTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountTokenId, true), gettype($accountTokenId)), __LINE__);
        }
        $this->accountTokenId = $accountTokenId;
        return $this;
    }
    /**
     * Get mailTokenId value
     * @return string|null
     */
    public function getMailTokenId()
    {
        return $this->mailTokenId;
    }
    /**
     * Set mailTokenId value
     * @param string $mailTokenId
     * @return \StructType\ValidateMailActivation
     */
    public function setMailTokenId($mailTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($mailTokenId) && !is_string($mailTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailTokenId, true), gettype($mailTokenId)), __LINE__);
        }
        $this->mailTokenId = $mailTokenId;
        return $this;
    }
    /**
     * Get activationCode value
     * @return string|null
     */
    public function getActivationCode()
    {
        return $this->activationCode;
    }
    /**
     * Set activationCode value
     * @param string $activationCode
     * @return \StructType\ValidateMailActivation
     */
    public function setActivationCode($activationCode = null)
    {
        // validation for constraint: string
        if (!is_null($activationCode) && !is_string($activationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activationCode, true), gettype($activationCode)), __LINE__);
        }
        $this->activationCode = $activationCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidateMailActivation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
