<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateWalletDescription StructType
 * @subpackage Structs
 */
class UpdateWalletDescription extends AbstractStructBase
{
    /**
     * The walletId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $walletId;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The walletDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $walletDesc;
    /**
     * Constructor method for UpdateWalletDescription
     * @uses UpdateWalletDescription::setWalletId()
     * @uses UpdateWalletDescription::setTokenId()
     * @uses UpdateWalletDescription::setWalletDesc()
     * @param int $walletId
     * @param string $tokenId
     * @param string $walletDesc
     */
    public function __construct($walletId = null, $tokenId = null, $walletDesc = null)
    {
        $this
            ->setWalletId($walletId)
            ->setTokenId($tokenId)
            ->setWalletDesc($walletDesc);
    }
    /**
     * Get walletId value
     * @return int
     */
    public function getWalletId()
    {
        return $this->walletId;
    }
    /**
     * Set walletId value
     * @param int $walletId
     * @return \StructType\UpdateWalletDescription
     */
    public function setWalletId($walletId = null)
    {
        // validation for constraint: int
        if (!is_null($walletId) && !(is_int($walletId) || ctype_digit($walletId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($walletId, true), gettype($walletId)), __LINE__);
        }
        $this->walletId = $walletId;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\UpdateWalletDescription
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get walletDesc value
     * @return string|null
     */
    public function getWalletDesc()
    {
        return $this->walletDesc;
    }
    /**
     * Set walletDesc value
     * @param string $walletDesc
     * @return \StructType\UpdateWalletDescription
     */
    public function setWalletDesc($walletDesc = null)
    {
        // validation for constraint: string
        if (!is_null($walletDesc) && !is_string($walletDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletDesc, true), gettype($walletDesc)), __LINE__);
        }
        $this->walletDesc = $walletDesc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateWalletDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
