<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMobilePin StructType
 * @subpackage Structs
 */
class UpdateMobilePin extends AbstractStructBase
{
    /**
     * The pin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pin;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The deviceKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceKey;
    /**
     * The pass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pass;
    /**
     * Constructor method for UpdateMobilePin
     * @uses UpdateMobilePin::setPin()
     * @uses UpdateMobilePin::setTokenId()
     * @uses UpdateMobilePin::setDeviceKey()
     * @uses UpdateMobilePin::setPass()
     * @param int $pin
     * @param string $tokenId
     * @param string $deviceKey
     * @param string $pass
     */
    public function __construct($pin = null, $tokenId = null, $deviceKey = null, $pass = null)
    {
        $this
            ->setPin($pin)
            ->setTokenId($tokenId)
            ->setDeviceKey($deviceKey)
            ->setPass($pass);
    }
    /**
     * Get pin value
     * @return int
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @param int $pin
     * @return \StructType\UpdateMobilePin
     */
    public function setPin($pin = null)
    {
        // validation for constraint: int
        if (!is_null($pin) && !(is_int($pin) || ctype_digit($pin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pin, true), gettype($pin)), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\UpdateMobilePin
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get deviceKey value
     * @return string|null
     */
    public function getDeviceKey()
    {
        return $this->deviceKey;
    }
    /**
     * Set deviceKey value
     * @param string $deviceKey
     * @return \StructType\UpdateMobilePin
     */
    public function setDeviceKey($deviceKey = null)
    {
        // validation for constraint: string
        if (!is_null($deviceKey) && !is_string($deviceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceKey, true), gettype($deviceKey)), __LINE__);
        }
        $this->deviceKey = $deviceKey;
        return $this;
    }
    /**
     * Get pass value
     * @return string|null
     */
    public function getPass()
    {
        return $this->pass;
    }
    /**
     * Set pass value
     * @param string $pass
     * @return \StructType\UpdateMobilePin
     */
    public function setPass($pass = null)
    {
        // validation for constraint: string
        if (!is_null($pass) && !is_string($pass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pass, true), gettype($pass)), __LINE__);
        }
        $this->pass = $pass;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateMobilePin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
