<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAccountIdentity StructType
 * @subpackage Structs
 */
class UpdateAccountIdentity extends AbstractStructBase
{
    /**
     * The TcNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TcNo;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The birthDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $birthDate;
    /**
     * Constructor method for UpdateAccountIdentity
     * @uses UpdateAccountIdentity::setTcNo()
     * @uses UpdateAccountIdentity::setTokenId()
     * @uses UpdateAccountIdentity::setBirthDate()
     * @param int $tcNo
     * @param string $tokenId
     * @param string $birthDate
     */
    public function __construct($tcNo = null, $tokenId = null, $birthDate = null)
    {
        $this
            ->setTcNo($tcNo)
            ->setTokenId($tokenId)
            ->setBirthDate($birthDate);
    }
    /**
     * Get TcNo value
     * @return int
     */
    public function getTcNo()
    {
        return $this->TcNo;
    }
    /**
     * Set TcNo value
     * @param int $tcNo
     * @return \StructType\UpdateAccountIdentity
     */
    public function setTcNo($tcNo = null)
    {
        // validation for constraint: int
        if (!is_null($tcNo) && !(is_int($tcNo) || ctype_digit($tcNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tcNo, true), gettype($tcNo)), __LINE__);
        }
        $this->TcNo = $tcNo;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\UpdateAccountIdentity
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\UpdateAccountIdentity
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateAccountIdentity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
