<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingPaywithCreditCartCodeforCart StructType
 * @subpackage Structs
 */
class ShoppingPaywithCreditCartCodeforCart extends AbstractStructBase
{
    /**
     * The isShipping
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isShipping;
    /**
     * The shippingAdressId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $shippingAdressId;
    /**
     * The billingAdressId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $billingAdressId;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The cardToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cardToken;
    /**
     * The productList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfShoppingCartEntity
     */
    public $productList;
    /**
     * Constructor method for ShoppingPaywithCreditCartCodeforCart
     * @uses ShoppingPaywithCreditCartCodeforCart::setIsShipping()
     * @uses ShoppingPaywithCreditCartCodeforCart::setShippingAdressId()
     * @uses ShoppingPaywithCreditCartCodeforCart::setBillingAdressId()
     * @uses ShoppingPaywithCreditCartCodeforCart::setTokenId()
     * @uses ShoppingPaywithCreditCartCodeforCart::setCardToken()
     * @uses ShoppingPaywithCreditCartCodeforCart::setProductList()
     * @param bool $isShipping
     * @param int $shippingAdressId
     * @param int $billingAdressId
     * @param string $tokenId
     * @param string $cardToken
     * @param \ArrayType\ArrayOfShoppingCartEntity $productList
     */
    public function __construct($isShipping = null, $shippingAdressId = null, $billingAdressId = null, $tokenId = null, $cardToken = null, \ArrayType\ArrayOfShoppingCartEntity $productList = null)
    {
        $this
            ->setIsShipping($isShipping)
            ->setShippingAdressId($shippingAdressId)
            ->setBillingAdressId($billingAdressId)
            ->setTokenId($tokenId)
            ->setCardToken($cardToken)
            ->setProductList($productList);
    }
    /**
     * Get isShipping value
     * @return bool
     */
    public function getIsShipping()
    {
        return $this->isShipping;
    }
    /**
     * Set isShipping value
     * @param bool $isShipping
     * @return \StructType\ShoppingPaywithCreditCartCodeforCart
     */
    public function setIsShipping($isShipping = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShipping) && !is_bool($isShipping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isShipping, true), gettype($isShipping)), __LINE__);
        }
        $this->isShipping = $isShipping;
        return $this;
    }
    /**
     * Get shippingAdressId value
     * @return int
     */
    public function getShippingAdressId()
    {
        return $this->shippingAdressId;
    }
    /**
     * Set shippingAdressId value
     * @param int $shippingAdressId
     * @return \StructType\ShoppingPaywithCreditCartCodeforCart
     */
    public function setShippingAdressId($shippingAdressId = null)
    {
        // validation for constraint: int
        if (!is_null($shippingAdressId) && !(is_int($shippingAdressId) || ctype_digit($shippingAdressId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shippingAdressId, true), gettype($shippingAdressId)), __LINE__);
        }
        $this->shippingAdressId = $shippingAdressId;
        return $this;
    }
    /**
     * Get billingAdressId value
     * @return int
     */
    public function getBillingAdressId()
    {
        return $this->billingAdressId;
    }
    /**
     * Set billingAdressId value
     * @param int $billingAdressId
     * @return \StructType\ShoppingPaywithCreditCartCodeforCart
     */
    public function setBillingAdressId($billingAdressId = null)
    {
        // validation for constraint: int
        if (!is_null($billingAdressId) && !(is_int($billingAdressId) || ctype_digit($billingAdressId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($billingAdressId, true), gettype($billingAdressId)), __LINE__);
        }
        $this->billingAdressId = $billingAdressId;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\ShoppingPaywithCreditCartCodeforCart
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get cardToken value
     * @return string|null
     */
    public function getCardToken()
    {
        return $this->cardToken;
    }
    /**
     * Set cardToken value
     * @param string $cardToken
     * @return \StructType\ShoppingPaywithCreditCartCodeforCart
     */
    public function setCardToken($cardToken = null)
    {
        // validation for constraint: string
        if (!is_null($cardToken) && !is_string($cardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardToken, true), gettype($cardToken)), __LINE__);
        }
        $this->cardToken = $cardToken;
        return $this;
    }
    /**
     * Get productList value
     * @return \ArrayType\ArrayOfShoppingCartEntity|null
     */
    public function getProductList()
    {
        return $this->productList;
    }
    /**
     * Set productList value
     * @param \ArrayType\ArrayOfShoppingCartEntity $productList
     * @return \StructType\ShoppingPaywithCreditCartCodeforCart
     */
    public function setProductList(\ArrayType\ArrayOfShoppingCartEntity $productList = null)
    {
        $this->productList = $productList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShoppingPaywithCreditCartCodeforCart
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
