<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingGetAdressDetail StructType
 * @subpackage Structs
 */
class ShoppingGetAdressDetail extends AbstractStructBase
{
    /**
     * The adressId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $adressId;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * Constructor method for ShoppingGetAdressDetail
     * @uses ShoppingGetAdressDetail::setAdressId()
     * @uses ShoppingGetAdressDetail::setTokenId()
     * @param int $adressId
     * @param string $tokenId
     */
    public function __construct($adressId = null, $tokenId = null)
    {
        $this
            ->setAdressId($adressId)
            ->setTokenId($tokenId);
    }
    /**
     * Get adressId value
     * @return int
     */
    public function getAdressId()
    {
        return $this->adressId;
    }
    /**
     * Set adressId value
     * @param int $adressId
     * @return \StructType\ShoppingGetAdressDetail
     */
    public function setAdressId($adressId = null)
    {
        // validation for constraint: int
        if (!is_null($adressId) && !(is_int($adressId) || ctype_digit($adressId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adressId, true), gettype($adressId)), __LINE__);
        }
        $this->adressId = $adressId;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\ShoppingGetAdressDetail
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShoppingGetAdressDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
