<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingCartEntity StructType
 * @subpackage Structs
 */
class ShoppingCartEntity extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountId;
    /**
     * The CompanyAccountId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CompanyAccountId;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Quantity;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalAmount;
    /**
     * The IsDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsActived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActived;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The CreateDateString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateDateString;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductId;
    /**
     * The ProductDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDetail;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The CategoryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryName;
    /**
     * The ProductImageUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductImageUrl;
    /**
     * The CompanyImageUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyImageUrl;
    /**
     * Constructor method for ShoppingCartEntity
     * @uses ShoppingCartEntity::setId()
     * @uses ShoppingCartEntity::setAccountId()
     * @uses ShoppingCartEntity::setCompanyAccountId()
     * @uses ShoppingCartEntity::setQuantity()
     * @uses ShoppingCartEntity::setAmount()
     * @uses ShoppingCartEntity::setTotalAmount()
     * @uses ShoppingCartEntity::setIsDeleted()
     * @uses ShoppingCartEntity::setIsActived()
     * @uses ShoppingCartEntity::setCreateDate()
     * @uses ShoppingCartEntity::setCreateDateString()
     * @uses ShoppingCartEntity::setOrderId()
     * @uses ShoppingCartEntity::setProductName()
     * @uses ShoppingCartEntity::setProductId()
     * @uses ShoppingCartEntity::setProductDetail()
     * @uses ShoppingCartEntity::setDescription()
     * @uses ShoppingCartEntity::setCategoryName()
     * @uses ShoppingCartEntity::setProductImageUrl()
     * @uses ShoppingCartEntity::setCompanyImageUrl()
     * @param int $id
     * @param int $accountId
     * @param int $companyAccountId
     * @param int $quantity
     * @param float $amount
     * @param float $totalAmount
     * @param bool $isDeleted
     * @param bool $isActived
     * @param string $createDate
     * @param string $createDateString
     * @param string $orderId
     * @param string $productName
     * @param string $productId
     * @param string $productDetail
     * @param string $description
     * @param string $categoryName
     * @param string $productImageUrl
     * @param string $companyImageUrl
     */
    public function __construct($id = null, $accountId = null, $companyAccountId = null, $quantity = null, $amount = null, $totalAmount = null, $isDeleted = null, $isActived = null, $createDate = null, $createDateString = null, $orderId = null, $productName = null, $productId = null, $productDetail = null, $description = null, $categoryName = null, $productImageUrl = null, $companyImageUrl = null)
    {
        $this
            ->setId($id)
            ->setAccountId($accountId)
            ->setCompanyAccountId($companyAccountId)
            ->setQuantity($quantity)
            ->setAmount($amount)
            ->setTotalAmount($totalAmount)
            ->setIsDeleted($isDeleted)
            ->setIsActived($isActived)
            ->setCreateDate($createDate)
            ->setCreateDateString($createDateString)
            ->setOrderId($orderId)
            ->setProductName($productName)
            ->setProductId($productId)
            ->setProductDetail($productDetail)
            ->setDescription($description)
            ->setCategoryName($categoryName)
            ->setProductImageUrl($productImageUrl)
            ->setCompanyImageUrl($companyImageUrl);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ShoppingCartEntity
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get AccountId value
     * @return int
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\ShoppingCartEntity
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get CompanyAccountId value
     * @return int
     */
    public function getCompanyAccountId()
    {
        return $this->CompanyAccountId;
    }
    /**
     * Set CompanyAccountId value
     * @param int $companyAccountId
     * @return \StructType\ShoppingCartEntity
     */
    public function setCompanyAccountId($companyAccountId = null)
    {
        // validation for constraint: int
        if (!is_null($companyAccountId) && !(is_int($companyAccountId) || ctype_digit($companyAccountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyAccountId, true), gettype($companyAccountId)), __LINE__);
        }
        $this->CompanyAccountId = $companyAccountId;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\ShoppingCartEntity
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ShoppingCartEntity
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \StructType\ShoppingCartEntity
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\ShoppingCartEntity
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get IsActived value
     * @return bool
     */
    public function getIsActived()
    {
        return $this->IsActived;
    }
    /**
     * Set IsActived value
     * @param bool $isActived
     * @return \StructType\ShoppingCartEntity
     */
    public function setIsActived($isActived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActived) && !is_bool($isActived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActived, true), gettype($isActived)), __LINE__);
        }
        $this->IsActived = $isActived;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\ShoppingCartEntity
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CreateDateString value
     * @return string|null
     */
    public function getCreateDateString()
    {
        return $this->CreateDateString;
    }
    /**
     * Set CreateDateString value
     * @param string $createDateString
     * @return \StructType\ShoppingCartEntity
     */
    public function setCreateDateString($createDateString = null)
    {
        // validation for constraint: string
        if (!is_null($createDateString) && !is_string($createDateString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateString, true), gettype($createDateString)), __LINE__);
        }
        $this->CreateDateString = $createDateString;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \StructType\ShoppingCartEntity
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\ShoppingCartEntity
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ProductId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param string $productId
     * @return \StructType\ShoppingCartEntity
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductDetail value
     * @return string|null
     */
    public function getProductDetail()
    {
        return $this->ProductDetail;
    }
    /**
     * Set ProductDetail value
     * @param string $productDetail
     * @return \StructType\ShoppingCartEntity
     */
    public function setProductDetail($productDetail = null)
    {
        // validation for constraint: string
        if (!is_null($productDetail) && !is_string($productDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productDetail, true), gettype($productDetail)), __LINE__);
        }
        $this->ProductDetail = $productDetail;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ShoppingCartEntity
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CategoryName value
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->CategoryName;
    }
    /**
     * Set CategoryName value
     * @param string $categoryName
     * @return \StructType\ShoppingCartEntity
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryName, true), gettype($categoryName)), __LINE__);
        }
        $this->CategoryName = $categoryName;
        return $this;
    }
    /**
     * Get ProductImageUrl value
     * @return string|null
     */
    public function getProductImageUrl()
    {
        return $this->ProductImageUrl;
    }
    /**
     * Set ProductImageUrl value
     * @param string $productImageUrl
     * @return \StructType\ShoppingCartEntity
     */
    public function setProductImageUrl($productImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($productImageUrl) && !is_string($productImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productImageUrl, true), gettype($productImageUrl)), __LINE__);
        }
        $this->ProductImageUrl = $productImageUrl;
        return $this;
    }
    /**
     * Get CompanyImageUrl value
     * @return string|null
     */
    public function getCompanyImageUrl()
    {
        return $this->CompanyImageUrl;
    }
    /**
     * Set CompanyImageUrl value
     * @param string $companyImageUrl
     * @return \StructType\ShoppingCartEntity
     */
    public function setCompanyImageUrl($companyImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($companyImageUrl) && !is_string($companyImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyImageUrl, true), gettype($companyImageUrl)), __LINE__);
        }
        $this->CompanyImageUrl = $companyImageUrl;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShoppingCartEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
