<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingAdressUpdate StructType
 * @subpackage Structs
 */
class ShoppingAdressUpdate extends AbstractStructBase
{
    /**
     * The adressId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $adressId;
    /**
     * The countryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $countryId;
    /**
     * The cityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $cityId;
    /**
     * The countyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $countyId;
    /**
     * The tokenId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tokenId;
    /**
     * The adress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adress;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * Constructor method for ShoppingAdressUpdate
     * @uses ShoppingAdressUpdate::setAdressId()
     * @uses ShoppingAdressUpdate::setCountryId()
     * @uses ShoppingAdressUpdate::setCityId()
     * @uses ShoppingAdressUpdate::setCountyId()
     * @uses ShoppingAdressUpdate::setTokenId()
     * @uses ShoppingAdressUpdate::setAdress()
     * @uses ShoppingAdressUpdate::setDescription()
     * @param int $adressId
     * @param int $countryId
     * @param int $cityId
     * @param int $countyId
     * @param string $tokenId
     * @param string $adress
     * @param string $description
     */
    public function __construct($adressId = null, $countryId = null, $cityId = null, $countyId = null, $tokenId = null, $adress = null, $description = null)
    {
        $this
            ->setAdressId($adressId)
            ->setCountryId($countryId)
            ->setCityId($cityId)
            ->setCountyId($countyId)
            ->setTokenId($tokenId)
            ->setAdress($adress)
            ->setDescription($description);
    }
    /**
     * Get adressId value
     * @return int
     */
    public function getAdressId()
    {
        return $this->adressId;
    }
    /**
     * Set adressId value
     * @param int $adressId
     * @return \StructType\ShoppingAdressUpdate
     */
    public function setAdressId($adressId = null)
    {
        // validation for constraint: int
        if (!is_null($adressId) && !(is_int($adressId) || ctype_digit($adressId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adressId, true), gettype($adressId)), __LINE__);
        }
        $this->adressId = $adressId;
        return $this;
    }
    /**
     * Get countryId value
     * @return int
     */
    public function getCountryId()
    {
        return $this->countryId;
    }
    /**
     * Set countryId value
     * @param int $countryId
     * @return \StructType\ShoppingAdressUpdate
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: int
        if (!is_null($countryId) && !(is_int($countryId) || ctype_digit($countryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        $this->countryId = $countryId;
        return $this;
    }
    /**
     * Get cityId value
     * @return int
     */
    public function getCityId()
    {
        return $this->cityId;
    }
    /**
     * Set cityId value
     * @param int $cityId
     * @return \StructType\ShoppingAdressUpdate
     */
    public function setCityId($cityId = null)
    {
        // validation for constraint: int
        if (!is_null($cityId) && !(is_int($cityId) || ctype_digit($cityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cityId, true), gettype($cityId)), __LINE__);
        }
        $this->cityId = $cityId;
        return $this;
    }
    /**
     * Get countyId value
     * @return int
     */
    public function getCountyId()
    {
        return $this->countyId;
    }
    /**
     * Set countyId value
     * @param int $countyId
     * @return \StructType\ShoppingAdressUpdate
     */
    public function setCountyId($countyId = null)
    {
        // validation for constraint: int
        if (!is_null($countyId) && !(is_int($countyId) || ctype_digit($countyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countyId, true), gettype($countyId)), __LINE__);
        }
        $this->countyId = $countyId;
        return $this;
    }
    /**
     * Get tokenId value
     * @return string|null
     */
    public function getTokenId()
    {
        return $this->tokenId;
    }
    /**
     * Set tokenId value
     * @param string $tokenId
     * @return \StructType\ShoppingAdressUpdate
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        $this->tokenId = $tokenId;
        return $this;
    }
    /**
     * Get adress value
     * @return string|null
     */
    public function getAdress()
    {
        return $this->adress;
    }
    /**
     * Set adress value
     * @param string $adress
     * @return \StructType\ShoppingAdressUpdate
     */
    public function setAdress($adress = null)
    {
        // validation for constraint: string
        if (!is_null($adress) && !is_string($adress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adress, true), gettype($adress)), __LINE__);
        }
        $this->adress = $adress;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ShoppingAdressUpdate
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShoppingAdressUpdate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
